/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services.push;

import io.intino.alexandria.Json;
import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.requesters.DisplayPushRequester;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.services.push.UISession;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.api.Session;

public class PushService
extends io.intino.alexandria.http.spark.PushService<UISession, UIClient> {
    private Map<String, DisplayPushRequester> requesterMap = new HashMap<String, DisplayPushRequester>();
    private static final Map<String, Consumer<Long>> linkedListeners = new HashMap<String, Consumer<Long>>();

    public UISession createSession(String id) {
        return new UISession(id);
    }

    public UIClient createClient(Session session) {
        return new UIClient(session);
    }

    public void linkToThread(UIClient client) {
        super.linkToThread((Client)client);
        if (linkedListeners.containsKey(client.id())) {
            linkedListeners.get(client.id()).accept(Thread.currentThread().getId());
        }
    }

    public void onMessage(UIClient client, String content) {
        UIMessage message = (UIMessage)Json.fromString((String)PushService.decode(content), UIMessage.class);
        String requester = message.sender();
        if (requester == null) {
            super.onMessage((Client)client, content);
            return;
        }
        try {
            this.linkToThread(client);
            this.requesterMap.get(requester).execute(client, message);
            this.unlinkFromThread();
        }
        catch (Throwable e) {
            if (e instanceof EofException) {
                Logger.debug((String)e.getMessage());
            }
            Logger.error((Throwable)e);
        }
    }

    public void onClose(UIClient client) {
        super.onClose((Client)client);
        linkedListeners.remove(client.id());
    }

    public void onLinkedToThread(Client client, Consumer<Long> listener) {
        linkedListeners.put(client.id(), listener);
    }

    public PushService register(String type, DisplayPushRequester requester) {
        this.requesterMap.put(type, requester);
        return this;
    }

    private static String decode(String object) {
        try {
            return URLDecoder.decode(object, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            return object;
        }
    }
}

