/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractBaseSorting;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.SelectEvent;
import io.intino.alexandria.ui.displays.events.SelectListener;
import io.intino.alexandria.ui.displays.notifiers.BaseSortingNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BaseSorting<DN extends BaseSortingNotifier, B extends Box>
extends AbstractBaseSorting<DN, B> {
    private SelectListener selectListener;
    private List<Collection> collections = new ArrayList<Collection>();
    private boolean selected = false;

    public BaseSorting(B box) {
        super(box);
    }

    public BaseSorting<DN, B> onSelect(SelectListener listener) {
        this.selectListener = listener;
        return this;
    }

    public BaseSorting<DN, B> bindTo(Collection ... collections) {
        this.collections = Arrays.stream(collections).filter(Objects::nonNull).collect(Collectors.toList());
        return this;
    }

    public void toggle() {
        this.selected = !this.selected;
        this.notifySelected();
    }

    private void notifySelected() {
        this.notifyCollections();
        this.notifyListener();
    }

    private void notifyCollections() {
        this.collections.forEach(c -> {
            if (this.selected) {
                c.addSorting(this.key());
            } else {
                c.removeSorting(this.key());
            }
        });
    }

    private void notifyListener() {
        if (this.selectListener == null) {
            return;
        }
        this.selectListener.accept(new SelectEvent(this, this.key()));
    }

    private String key() {
        return this.label() != null && !this.label().isEmpty() ? this.label() : this.name();
    }
}

