package io.intino.alexandria.ui;
import io.intino.alexandria.ui.displays.*;
import io.intino.alexandria.ui.displays.notifiers.*;
import io.intino.alexandria.ui.displays.requesters.*;
import io.intino.alexandria.ui.resources.*;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.UiFrameworkConfiguration;

import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class UiElementsService extends io.intino.alexandria.ui.UI {

	public static void init(UISpark spark, UiFrameworkBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		UiFrameworkConfiguration configuration = (UiFrameworkConfiguration) box.configuration();
		box.routeManager(routeManager(spark, routeDispatcher));
		spark.route("/push").push(pushService);
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		spark.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		spark.route("/docs").get(manager -> new DocsResource(box, manager, notifierProvider()).execute());
		spark.route("/docs/data/:type/").get(manager -> new WidgetTypeResource(box, manager, notifierProvider()).execute());
		spark.route("/docs/data/microsite/:page").get(manager -> new MicroSiteResource(box, manager, notifierProvider()).execute());
		initDisplays(spark, pushService);
	}

	public static void initDisplays(UISpark spark, PushService pushService) {
		spark.route("/groupingtoolbarexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/groupingtoolbarexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/groupingtoolbarexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbarexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/collection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/collection/:displayId").post(manager -> new CollectionRequester(manager, notifierProvider()).execute());
		spark.route("/collection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("collection", new CollectionPushRequester());

		spark.route("/pagecollection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/pagecollection/:displayId").post(manager -> new PageCollectionRequester(manager, notifierProvider()).execute());
		spark.route("/pagecollection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("pagecollection", new PageCollectionPushRequester());

		spark.route("/dynamictable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dynamictable/:displayId").post(manager -> new DynamicTableRequester(manager, notifierProvider()).execute());
		spark.route("/dynamictable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictable", new DynamicTablePushRequester());

		spark.route("/map/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/map/:displayId").post(manager -> new MapRequester(manager, notifierProvider()).execute());
		spark.route("/map/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map", new MapPushRequester());

		spark.route("/list/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list/:displayId").post(manager -> new ListRequester(manager, notifierProvider()).execute());
		spark.route("/list/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list", new ListPushRequester());

		spark.route("/table/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table/:displayId").post(manager -> new TableRequester(manager, notifierProvider()).execute());
		spark.route("/table/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table", new TablePushRequester());

		spark.route("/magazine/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/magazine/:displayId").post(manager -> new MagazineRequester(manager, notifierProvider()).execute());
		spark.route("/magazine/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("magazine", new MagazinePushRequester());

		spark.route("/item/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/item/:displayId").post(manager -> new ItemRequester(manager, notifierProvider()).execute());
		spark.route("/item/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("item", new ItemPushRequester());

		spark.route("/heading/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/heading/:displayId").post(manager -> new HeadingRequester(manager, notifierProvider()).execute());
		spark.route("/heading/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("heading", new HeadingPushRequester());

		spark.route("/row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/row/:displayId").post(manager -> new RowRequester(manager, notifierProvider()).execute());
		spark.route("/row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("row", new RowPushRequester());

		spark.route("/basegrouping/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basegrouping/:displayId").post(manager -> new BaseGroupingRequester(manager, notifierProvider()).execute());
		spark.route("/basegrouping/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basegrouping", new BaseGroupingPushRequester());

		spark.route("/grouping/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/grouping/:displayId").post(manager -> new GroupingRequester(manager, notifierProvider()).execute());
		spark.route("/grouping/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping", new GroupingPushRequester());

		spark.route("/groupingcombobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/groupingcombobox/:displayId").post(manager -> new GroupingComboBoxRequester(manager, notifierProvider()).execute());
		spark.route("/groupingcombobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingcombobox", new GroupingComboBoxPushRequester());

		spark.route("/groupingtoolbar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/groupingtoolbar/:displayId").post(manager -> new GroupingToolbarRequester(manager, notifierProvider()).execute());
		spark.route("/groupingtoolbar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbar", new GroupingToolbarPushRequester());

		spark.route("/basesorting/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basesorting/:displayId").post(manager -> new BaseSortingRequester(manager, notifierProvider()).execute());
		spark.route("/basesorting/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basesorting", new BaseSortingPushRequester());

		spark.route("/sorting/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sorting/:displayId").post(manager -> new SortingRequester(manager, notifierProvider()).execute());
		spark.route("/sorting/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting", new SortingPushRequester());

		spark.route("/sortingorderby/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sortingorderby/:displayId").post(manager -> new SortingOrderByRequester(manager, notifierProvider()).execute());
		spark.route("/sortingorderby/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sortingorderby", new SortingOrderByPushRequester());

		spark.route("/searchbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/searchbox/:displayId").post(manager -> new SearchBoxRequester(manager, notifierProvider()).execute());
		spark.route("/searchbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchbox", new SearchBoxPushRequester());

		spark.route("/downloadselectionexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/downloadselectionexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/downloadselectionexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselectionexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/itemmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/itemmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/itemmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("itemmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/dateexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dateexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/dateexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dateexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/locationexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/locationexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/locationexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("locationexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/dynamictableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dynamictableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/dynamictableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/numberexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/numberexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/numberexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("numberexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/widgettypetemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/widgettypetemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/widgettypetemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgettypetemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/downloadexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/downloadexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/downloadexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/exportexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/exportexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/exportexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("exportexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/tableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/tableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/tableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/sortingexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sortingexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/sortingexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sortingexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/userexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/userexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/userexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("userexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/imageexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/imageexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/imageexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/dashboardexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dashboardexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/dashboardexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/blockexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/blockexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/selectorexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/selectorexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/sliderexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sliderexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/sliderexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sliderexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/groupingexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/groupingexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/groupingexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/toolbar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/toolbar/:displayId").post(manager -> new ToolbarRequester(manager, notifierProvider()).execute());
		spark.route("/toolbar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("toolbar", new ToolbarPushRequester());

		spark.route("/actionable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/actionable/:displayId").post(manager -> new ActionableRequester(manager, notifierProvider()).execute());
		spark.route("/actionable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionable", new ActionablePushRequester());

		spark.route("/action/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/action/:displayId").post(manager -> new ActionRequester(manager, notifierProvider()).execute());
		spark.route("/action/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("action", new ActionPushRequester());

		spark.route("/actionsplit/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/actionsplit/:displayId").post(manager -> new ActionSplitRequester(manager, notifierProvider()).execute());
		spark.route("/actionsplit/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionsplit", new ActionSplitPushRequester());

		spark.route("/actionswitch/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/actionswitch/:displayId").post(manager -> new ActionSwitchRequester(manager, notifierProvider()).execute());
		spark.route("/actionswitch/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionswitch", new ActionSwitchPushRequester());

		spark.route("/actiontoggle/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/actiontoggle/:displayId").post(manager -> new ActionToggleRequester(manager, notifierProvider()).execute());
		spark.route("/actiontoggle/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actiontoggle", new ActionTogglePushRequester());

		spark.route("/export/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/export/:displayId").post(manager -> new ExportRequester(manager, notifierProvider()).execute());
		spark.route("/export/:displayId").get(manager -> new ExportRequester(manager, notifierProvider()).execute());
		spark.route("/export/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("export", new ExportPushRequester());

		spark.route("/download/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/download/:displayId").post(manager -> new DownloadRequester(manager, notifierProvider()).execute());
		spark.route("/download/:displayId").get(manager -> new DownloadRequester(manager, notifierProvider()).execute());
		spark.route("/download/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("download", new DownloadPushRequester());

		spark.route("/openpage/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/openpage/:displayId").post(manager -> new OpenPageRequester(manager, notifierProvider()).execute());
		spark.route("/openpage/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openpage", new OpenPagePushRequester());

		spark.route("/opensite/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/opensite/:displayId").post(manager -> new OpenSiteRequester(manager, notifierProvider()).execute());
		spark.route("/opensite/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opensite", new OpenSitePushRequester());

		spark.route("/openblock/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/openblock/:displayId").post(manager -> new OpenBlockRequester(manager, notifierProvider()).execute());
		spark.route("/openblock/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openblock", new OpenBlockPushRequester());

		spark.route("/opendialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/opendialog/:displayId").post(manager -> new OpenDialogRequester(manager, notifierProvider()).execute());
		spark.route("/opendialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opendialog", new OpenDialogPushRequester());

		spark.route("/openpopover/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/openpopover/:displayId").post(manager -> new OpenPopoverRequester(manager, notifierProvider()).execute());
		spark.route("/openpopover/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("openpopover", new OpenPopoverPushRequester());

		spark.route("/closedialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/closedialog/:displayId").post(manager -> new CloseDialogRequester(manager, notifierProvider()).execute());
		spark.route("/closedialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closedialog", new CloseDialogPushRequester());

		spark.route("/opendrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/opendrawer/:displayId").post(manager -> new OpenDrawerRequester(manager, notifierProvider()).execute());
		spark.route("/opendrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("opendrawer", new OpenDrawerPushRequester());

		spark.route("/closedrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/closedrawer/:displayId").post(manager -> new CloseDrawerRequester(manager, notifierProvider()).execute());
		spark.route("/closedrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("closedrawer", new CloseDrawerPushRequester());

		spark.route("/selectnextitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectnextitem/:displayId").post(manager -> new SelectNextItemRequester(manager, notifierProvider()).execute());
		spark.route("/selectnextitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectnextitem", new SelectNextItemPushRequester());

		spark.route("/selectpreviousitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectpreviousitem/:displayId").post(manager -> new SelectPreviousItemRequester(manager, notifierProvider()).execute());
		spark.route("/selectpreviousitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectpreviousitem", new SelectPreviousItemPushRequester());

		spark.route("/baseselectionaction/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baseselectionaction/:displayId").post(manager -> new BaseSelectionActionRequester(manager, notifierProvider()).execute());
		spark.route("/baseselectionaction/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseselectionaction", new BaseSelectionActionPushRequester());

		spark.route("/selectionaction/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectionaction/:displayId").post(manager -> new SelectionActionRequester(manager, notifierProvider()).execute());
		spark.route("/selectionaction/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectionaction", new SelectionActionPushRequester());

		spark.route("/downloadselection/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/downloadselection/:displayId").post(manager -> new DownloadSelectionRequester(manager, notifierProvider()).execute());
		spark.route("/downloadselection/:displayId").get(manager -> new DownloadSelectionRequester(manager, notifierProvider()).execute());
		spark.route("/downloadselection/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselection", new DownloadSelectionPushRequester());

		spark.route("/searchboxexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/searchboxexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/searchboxexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchboxexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/frameexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/frameexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/frameexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("frameexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/fileexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/fileexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/fileexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("fileexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/listexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/listexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/listexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("listexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/docstemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/docstemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/docstemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("docstemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/widgetsummarymold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/widgetsummarymold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/widgetsummarymold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetsummarymold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/chartexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/chartexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/chartexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chartexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/dialogexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dialogexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/dialogexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialogexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/desktop/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/desktop/:displayId").post(manager -> new DesktopRequester(manager, notifierProvider()).execute());
		spark.route("/desktop/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("desktop", new DesktopPushRequester());

		spark.route("/page/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/page/:displayId").post(manager -> new PageRequester(manager, notifierProvider()).execute());
		spark.route("/page/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("page", new PagePushRequester());

		spark.route("/pagedisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/pagedisplay/:displayId").post(manager -> new PageDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/pagedisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("pagedisplay", new PageDisplayPushRequester());

		spark.route("/displayrouter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/displayrouter/:displayId").post(manager -> new DisplayRouterRequester(manager, notifierProvider()).execute());
		spark.route("/displayrouter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("displayrouter", new DisplayRouterPushRequester());

		spark.route("/proxydisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/proxydisplay/:displayId").post(manager -> new ProxyDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/proxydisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("proxydisplay", new ProxyDisplayPushRequester());

		spark.route("/template/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/template/:displayId").post(manager -> new TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/template/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("template", new TemplatePushRequester());

		spark.route("/block/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/block/:displayId").post(manager -> new BlockRequester(manager, notifierProvider()).execute());
		spark.route("/block/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("block", new BlockPushRequester());

		spark.route("/blockconditional/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockconditional/:displayId").post(manager -> new BlockConditionalRequester(manager, notifierProvider()).execute());
		spark.route("/blockconditional/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockconditional", new BlockConditionalPushRequester());

		spark.route("/blocksplitter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blocksplitter/:displayId").post(manager -> new BlockSplitterRequester(manager, notifierProvider()).execute());
		spark.route("/blocksplitter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blocksplitter", new BlockSplitterPushRequester());

		spark.route("/blockparallax/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockparallax/:displayId").post(manager -> new BlockParallaxRequester(manager, notifierProvider()).execute());
		spark.route("/blockparallax/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockparallax", new BlockParallaxPushRequester());

		spark.route("/blockbadge/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockbadge/:displayId").post(manager -> new BlockBadgeRequester(manager, notifierProvider()).execute());
		spark.route("/blockbadge/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockbadge", new BlockBadgePushRequester());

		spark.route("/blockdrawer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockdrawer/:displayId").post(manager -> new BlockDrawerRequester(manager, notifierProvider()).execute());
		spark.route("/blockdrawer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockdrawer", new BlockDrawerPushRequester());

		spark.route("/blockpopover/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/blockpopover/:displayId").post(manager -> new BlockPopoverRequester(manager, notifierProvider()).execute());
		spark.route("/blockpopover/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("blockpopover", new BlockPopoverPushRequester());

		spark.route("/option/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/option/:displayId").post(manager -> new OptionRequester(manager, notifierProvider()).execute());
		spark.route("/option/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("option", new OptionPushRequester());

		spark.route("/chart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/chart/:displayId").post(manager -> new ChartRequester(manager, notifierProvider()).execute());
		spark.route("/chart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("chart", new ChartPushRequester());

		spark.route("/basedashboard/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basedashboard/:displayId").post(manager -> new BaseDashboardRequester(manager, notifierProvider()).execute());
		spark.route("/basedashboard/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedashboard", new BaseDashboardPushRequester());

		spark.route("/dashboardshiny/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dashboardshiny/:displayId").post(manager -> new DashboardShinyRequester(manager, notifierProvider()).execute());
		spark.route("/dashboardshiny/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardshiny", new DashboardShinyPushRequester());

		spark.route("/dashboardmetabase/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dashboardmetabase/:displayId").post(manager -> new DashboardMetabaseRequester(manager, notifierProvider()).execute());
		spark.route("/dashboardmetabase/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dashboardmetabase", new DashboardMetabasePushRequester());

		spark.route("/header/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/header/:displayId").post(manager -> new HeaderRequester(manager, notifierProvider()).execute());
		spark.route("/header/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("header", new HeaderPushRequester());

		spark.route("/tabs/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/tabs/:displayId").post(manager -> new TabsRequester(manager, notifierProvider()).execute());
		spark.route("/tabs/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tabs", new TabsPushRequester());

		spark.route("/tab/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/tab/:displayId").post(manager -> new TabRequester(manager, notifierProvider()).execute());
		spark.route("/tab/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("tab", new TabPushRequester());

		spark.route("/baseicon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baseicon/:displayId").post(manager -> new BaseIconRequester(manager, notifierProvider()).execute());
		spark.route("/baseicon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseicon", new BaseIconPushRequester());

		spark.route("/icon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/icon/:displayId").post(manager -> new IconRequester(manager, notifierProvider()).execute());
		spark.route("/icon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("icon", new IconPushRequester());

		spark.route("/materialicon/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/materialicon/:displayId").post(manager -> new MaterialIconRequester(manager, notifierProvider()).execute());
		spark.route("/materialicon/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("materialicon", new MaterialIconPushRequester());

		spark.route("/optionlist/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/optionlist/:displayId").post(manager -> new OptionListRequester(manager, notifierProvider()).execute());
		spark.route("/optionlist/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("optionlist", new OptionListPushRequester());

		spark.route("/baseselector/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baseselector/:displayId").post(manager -> new BaseSelectorRequester(manager, notifierProvider()).execute());
		spark.route("/baseselector/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseselector", new BaseSelectorPushRequester());

		spark.route("/selectormenu/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectormenu/:displayId").post(manager -> new SelectorMenuRequester(manager, notifierProvider()).execute());
		spark.route("/selectormenu/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectormenu", new SelectorMenuPushRequester());

		spark.route("/selectorradiobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorradiobox/:displayId").post(manager -> new SelectorRadioBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectorradiobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorradiobox", new SelectorRadioBoxPushRequester());

		spark.route("/selectorcheckbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorcheckbox/:displayId").post(manager -> new SelectorCheckBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectorcheckbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcheckbox", new SelectorCheckBoxPushRequester());

		spark.route("/selectorcombobox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorcombobox/:displayId").post(manager -> new SelectorComboBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectorcombobox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcombobox", new SelectorComboBoxPushRequester());

		spark.route("/selectortogglebox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectortogglebox/:displayId").post(manager -> new SelectorToggleBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectortogglebox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectortogglebox", new SelectorToggleBoxPushRequester());

		spark.route("/selectorlistbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorlistbox/:displayId").post(manager -> new SelectorListBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectorlistbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorlistbox", new SelectorListBoxPushRequester());

		spark.route("/selectortabs/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectortabs/:displayId").post(manager -> new SelectorTabsRequester(manager, notifierProvider()).execute());
		spark.route("/selectortabs/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectortabs", new SelectorTabsPushRequester());

		spark.route("/selectorcollectionbox/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selectorcollectionbox/:displayId").post(manager -> new SelectorCollectionBoxRequester(manager, notifierProvider()).execute());
		spark.route("/selectorcollectionbox/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selectorcollectionbox", new SelectorCollectionBoxPushRequester());

		spark.route("/multiple/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/multiple/:displayId").post(manager -> new MultipleRequester(manager, notifierProvider()).execute());
		spark.route("/multiple/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("multiple", new MultiplePushRequester());

		spark.route("/spinner/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/spinner/:displayId").post(manager -> new SpinnerRequester(manager, notifierProvider()).execute());
		spark.route("/spinner/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("spinner", new SpinnerPushRequester());

		spark.route("/baseslider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baseslider/:displayId").post(manager -> new BaseSliderRequester(manager, notifierProvider()).execute());
		spark.route("/baseslider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseslider", new BaseSliderPushRequester());

		spark.route("/slider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/slider/:displayId").post(manager -> new SliderRequester(manager, notifierProvider()).execute());
		spark.route("/slider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("slider", new SliderPushRequester());

		spark.route("/temporalslider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/temporalslider/:displayId").post(manager -> new TemporalSliderRequester(manager, notifierProvider()).execute());
		spark.route("/temporalslider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("temporalslider", new TemporalSliderPushRequester());

		spark.route("/templatestamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/templatestamp/:displayId").post(manager -> new TemplateStampRequester(manager, notifierProvider()).execute());
		spark.route("/templatestamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("templatestamp", new TemplateStampPushRequester());

		spark.route("/templatestampeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/templatestampeditable/:displayId").post(manager -> new TemplateStampEditableRequester(manager, notifierProvider()).execute());
		spark.route("/templatestampeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("templatestampeditable", new TemplateStampEditablePushRequester());

		spark.route("/displaystamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/displaystamp/:displayId").post(manager -> new DisplayStampRequester(manager, notifierProvider()).execute());
		spark.route("/displaystamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("displaystamp", new DisplayStampPushRequester());

		spark.route("/proxystamp/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/proxystamp/:displayId").post(manager -> new ProxyStampRequester(manager, notifierProvider()).execute());
		spark.route("/proxystamp/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("proxystamp", new ProxyStampPushRequester());

		spark.route("/microsite/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/microsite/:displayId").post(manager -> new MicroSiteRequester(manager, notifierProvider()).execute());
		spark.route("/microsite/:displayId").get(manager -> new MicroSiteRequester(manager, notifierProvider()).execute());
		spark.route("/microsite/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("microsite", new MicroSitePushRequester());

		spark.route("/frame/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/frame/:displayId").post(manager -> new FrameRequester(manager, notifierProvider()).execute());
		spark.route("/frame/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("frame", new FramePushRequester());

		spark.route("/basedialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basedialog/:displayId").post(manager -> new BaseDialogRequester(manager, notifierProvider()).execute());
		spark.route("/basedialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedialog", new BaseDialogPushRequester());

		spark.route("/dialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dialog/:displayId").post(manager -> new DialogRequester(manager, notifierProvider()).execute());
		spark.route("/dialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialog", new DialogPushRequester());

		spark.route("/alertdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/alertdialog/:displayId").post(manager -> new AlertDialogRequester(manager, notifierProvider()).execute());
		spark.route("/alertdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("alertdialog", new AlertDialogPushRequester());

		spark.route("/decisiondialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/decisiondialog/:displayId").post(manager -> new DecisionDialogRequester(manager, notifierProvider()).execute());
		spark.route("/decisiondialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("decisiondialog", new DecisionDialogPushRequester());

		spark.route("/collectiondialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/collectiondialog/:displayId").post(manager -> new CollectionDialogRequester(manager, notifierProvider()).execute());
		spark.route("/collectiondialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("collectiondialog", new CollectionDialogPushRequester());

		spark.route("/divider/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/divider/:displayId").post(manager -> new DividerRequester(manager, notifierProvider()).execute());
		spark.route("/divider/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("divider", new DividerPushRequester());

		spark.route("/user/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/user/:displayId").post(manager -> new UserRequester(manager, notifierProvider()).execute());
		spark.route("/user/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("user", new UserPushRequester());

		spark.route("/stepper/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/stepper/:displayId").post(manager -> new StepperRequester(manager, notifierProvider()).execute());
		spark.route("/stepper/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("stepper", new StepperPushRequester());

		spark.route("/step/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/step/:displayId").post(manager -> new StepRequester(manager, notifierProvider()).execute());
		spark.route("/step/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("step", new StepPushRequester());

		spark.route("/textexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/textexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/textexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("textexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/hometemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/hometemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/hometemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("hometemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/actionableexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/actionableexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/actionableexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("actionableexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/basenumber/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basenumber/:displayId").post(manager -> new BaseNumberRequester(manager, notifierProvider()).execute());
		spark.route("/basenumber/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basenumber", new BaseNumberPushRequester());

		spark.route("/number/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/number/:displayId").post(manager -> new NumberRequester(manager, notifierProvider()).execute());
		spark.route("/number/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("number", new NumberPushRequester());

		spark.route("/numbereditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/numbereditable/:displayId").post(manager -> new NumberEditableRequester(manager, notifierProvider()).execute());
		spark.route("/numbereditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("numbereditable", new NumberEditablePushRequester());

		spark.route("/basedate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basedate/:displayId").post(manager -> new BaseDateRequester(manager, notifierProvider()).execute());
		spark.route("/basedate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basedate", new BaseDatePushRequester());

		spark.route("/date/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/date/:displayId").post(manager -> new DateRequester(manager, notifierProvider()).execute());
		spark.route("/date/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("date", new DatePushRequester());

		spark.route("/dateeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dateeditable/:displayId").post(manager -> new DateEditableRequester(manager, notifierProvider()).execute());
		spark.route("/dateeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dateeditable", new DateEditablePushRequester());

		spark.route("/basetext/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basetext/:displayId").post(manager -> new BaseTextRequester(manager, notifierProvider()).execute());
		spark.route("/basetext/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basetext", new BaseTextPushRequester());

		spark.route("/text/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/text/:displayId").post(manager -> new TextRequester(manager, notifierProvider()).execute());
		spark.route("/text/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("text", new TextPushRequester());

		spark.route("/textcode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/textcode/:displayId").post(manager -> new TextCodeRequester(manager, notifierProvider()).execute());
		spark.route("/textcode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("textcode", new TextCodePushRequester());

		spark.route("/texteditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/texteditable/:displayId").post(manager -> new TextEditableRequester(manager, notifierProvider()).execute());
		spark.route("/texteditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("texteditable", new TextEditablePushRequester());

		spark.route("/texteditablecode/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/texteditablecode/:displayId").post(manager -> new TextEditableCodeRequester(manager, notifierProvider()).execute());
		spark.route("/texteditablecode/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("texteditablecode", new TextEditableCodePushRequester());

		spark.route("/basefile/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/basefile/:displayId").post(manager -> new BaseFileRequester(manager, notifierProvider()).execute());
		spark.route("/basefile/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("basefile", new BaseFilePushRequester());

		spark.route("/file/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/file/:displayId").post(manager -> new FileRequester(manager, notifierProvider()).execute());
		spark.route("/file/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("file", new FilePushRequester());

		spark.route("/fileeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/fileeditable/:displayId").post(manager -> new FileEditableRequester(manager, notifierProvider()).execute());
		spark.route("/fileeditable/:displayId").get(manager -> new FileEditableRequester(manager, notifierProvider()).execute());
		spark.route("/fileeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("fileeditable", new FileEditablePushRequester());

		spark.route("/baseimage/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baseimage/:displayId").post(manager -> new BaseImageRequester(manager, notifierProvider()).execute());
		spark.route("/baseimage/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baseimage", new BaseImagePushRequester());

		spark.route("/image/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/image/:displayId").post(manager -> new ImageRequester(manager, notifierProvider()).execute());
		spark.route("/image/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("image", new ImagePushRequester());

		spark.route("/imageavatar/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/imageavatar/:displayId").post(manager -> new ImageAvatarRequester(manager, notifierProvider()).execute());
		spark.route("/imageavatar/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageavatar", new ImageAvatarPushRequester());

		spark.route("/imageeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/imageeditable/:displayId").post(manager -> new ImageEditableRequester(manager, notifierProvider()).execute());
		spark.route("/imageeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("imageeditable", new ImageEditablePushRequester());

		spark.route("/baselocation/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/baselocation/:displayId").post(manager -> new BaseLocationRequester(manager, notifierProvider()).execute());
		spark.route("/baselocation/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("baselocation", new BaseLocationPushRequester());

		spark.route("/location/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/location/:displayId").post(manager -> new LocationRequester(manager, notifierProvider()).execute());
		spark.route("/location/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("location", new LocationPushRequester());

		spark.route("/locationeditable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/locationeditable/:displayId").post(manager -> new LocationEditableRequester(manager, notifierProvider()).execute());
		spark.route("/locationeditable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("locationeditable", new LocationEditablePushRequester());

		spark.route("/mapexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/mapexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/mapexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("mapexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/micrositeexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/micrositeexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/micrositeexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("micrositeexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/widgetmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/widgetmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/widgetmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("widgetmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/propertymold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/propertymold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/propertymold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("propertymold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/methodmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/methodmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/methodmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("methodmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/methodparammold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/methodparammold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/methodparammold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("methodparammold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/eventsdisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/eventsdisplay/:displayId").post(manager -> new EventsDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/eventsdisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("eventsdisplay", new EventsDisplayPushRequester());

		spark.route("/stepperexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/stepperexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/stepperexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("stepperexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/dividerexamplesmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dividerexamplesmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
		spark.route("/dividerexamplesmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dividerexamplesmold", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

		spark.route("/groupingtoolbar1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/groupingtoolbar1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/groupingtoolbar1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("groupingtoolbar1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/downloadselectionmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/downloadselectionmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/downloadselectionmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("downloadselectionmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/dynfirstnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dynfirstnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/dynfirstnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynfirstnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/dynlastnameitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dynlastnameitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/dynlastnameitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynlastnameitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/table11mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table11mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/table11mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table11mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/table12mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table12mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/table12mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table12mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/table21mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table21mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/table21mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table21mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/table22mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table22mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/table22mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table22mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/sorting1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sorting1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/sorting1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/sorting2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/sorting2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/sorting2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("sorting2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/selector8listmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/selector8listmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/selector8listmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("selector8listmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/grouping1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/grouping1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/grouping1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/grouping2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/grouping2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/grouping2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("grouping2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/searchbox1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/searchbox1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/searchbox1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("searchbox1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/list1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/list1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/list2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/list2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/list3mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list3mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/list3mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list3mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/list4mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list4mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/list4mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list4mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/list5mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/list5mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/list5mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("list5mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/dialog4listmold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dialog4listmold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/dialog4listmold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dialog4listmold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/map1mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/map1mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/map1mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map1mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/map2mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/map2mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/map2mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map2mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/map3mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/map3mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/map3mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map3mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/map4mold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/map4mold/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
		spark.route("/map4mold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("map4mold", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

		spark.route("/table1row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table1row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		spark.route("/table1row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table1row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

		spark.route("/table2row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/table2row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		spark.route("/table2row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("table2row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

		spark.route("/dynamictable1row/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dynamictable1row/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.RowRequester(manager, notifierProvider()).execute());
		spark.route("/dynamictable1row/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		pushService.register("dynamictable1row", new io.intino.alexandria.ui.displays.requesters.RowPushRequester());

		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.GroupingToolbarExamplesMold.class);
		register(CollectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Collection.class);
		register(PageCollectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.PageCollection.class);
		register(DynamicTableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DynamicTable.class);
		register(MapNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Map.class);
		register(ListNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.List.class);
		register(TableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Table.class);
		register(MagazineNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Magazine.class);
		register(ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Item.class);
		register(HeadingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Heading.class);
		register(RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Row.class);
		register(BaseGroupingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseGrouping.class);
		register(GroupingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Grouping.class);
		register(GroupingComboBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.GroupingComboBox.class);
		register(GroupingToolbarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.GroupingToolbar.class);
		register(BaseSortingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSorting.class);
		register(SortingNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Sorting.class);
		register(SortingOrderByNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SortingOrderBy.class);
		register(SearchBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SearchBox.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DownloadSelectionExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ItemMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DateExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.LocationExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DynamicTableExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.NumberExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetTypeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DownloadExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ExportExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.TableExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SortingExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.UserExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ImageExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DashboardExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.BlockExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SelectorExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SliderExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.GroupingExamplesMold.class);
		register(ToolbarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Toolbar.class);
		register(ActionableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Actionable.class);
		register(ActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Action.class);
		register(ActionSplitNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionSplit.class);
		register(ActionSwitchNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionSwitch.class);
		register(ActionToggleNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ActionToggle.class);
		register(ExportNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Export.class);
		register(DownloadNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Download.class);
		register(OpenPageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenPage.class);
		register(OpenSiteNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenSite.class);
		register(OpenBlockNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenBlock.class);
		register(OpenDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenDialog.class);
		register(OpenPopoverNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenPopover.class);
		register(CloseDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseDialog.class);
		register(OpenDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OpenDrawer.class);
		register(CloseDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CloseDrawer.class);
		register(SelectNextItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectNextItem.class);
		register(SelectPreviousItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectPreviousItem.class);
		register(BaseSelectionActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSelectionAction.class);
		register(SelectionActionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectionAction.class);
		register(DownloadSelectionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DownloadSelection.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.SearchBoxExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.FrameExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.FileExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ListExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DocsTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetSummaryMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ChartExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DialogExamplesMold.class);
		register(DesktopNotifier.class).forDisplay(io.intino.alexandria.ui.displays.Desktop.class);
		register(PageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.Page.class);
		register(PageDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.PageDisplay.class);
		register(DisplayRouterNotifier.class).forDisplay(io.intino.alexandria.ui.displays.DisplayRouter.class);
		register(ProxyDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.ProxyDisplay.class);
		register(TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Template.class);
		register(BlockNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Block.class);
		register(BlockConditionalNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockConditional.class);
		register(BlockSplitterNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockSplitter.class);
		register(BlockParallaxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockParallax.class);
		register(BlockBadgeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockBadge.class);
		register(BlockDrawerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockDrawer.class);
		register(BlockPopoverNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BlockPopover.class);
		register(OptionNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Option.class);
		register(ChartNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Chart.class);
		register(BaseDashboardNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDashboard.class);
		register(DashboardShinyNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DashboardShiny.class);
		register(DashboardMetabaseNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DashboardMetabase.class);
		register(HeaderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Header.class);
		register(TabsNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Tabs.class);
		register(TabNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Tab.class);
		register(BaseIconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseIcon.class);
		register(IconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Icon.class);
		register(MaterialIconNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.MaterialIcon.class);
		register(OptionListNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.OptionList.class);
		register(BaseSelectorNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSelector.class);
		register(SelectorMenuNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorMenu.class);
		register(SelectorRadioBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorRadioBox.class);
		register(SelectorCheckBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorCheckBox.class);
		register(SelectorComboBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorComboBox.class);
		register(SelectorToggleBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorToggleBox.class);
		register(SelectorListBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorListBox.class);
		register(SelectorTabsNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorTabs.class);
		register(SelectorCollectionBoxNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.SelectorCollectionBox.class);
		register(MultipleNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Multiple.class);
		register(SpinnerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Spinner.class);
		register(BaseSliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseSlider.class);
		register(SliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Slider.class);
		register(TemporalSliderNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemporalSlider.class);
		register(TemplateStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemplateStamp.class);
		register(TemplateStampEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TemplateStampEditable.class);
		register(DisplayStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DisplayStamp.class);
		register(ProxyStampNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ProxyStamp.class);
		register(MicroSiteNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.MicroSite.class);
		register(FrameNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Frame.class);
		register(BaseDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDialog.class);
		register(DialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Dialog.class);
		register(AlertDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.AlertDialog.class);
		register(DecisionDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DecisionDialog.class);
		register(CollectionDialogNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.CollectionDialog.class);
		register(DividerNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Divider.class);
		register(UserNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.User.class);
		register(StepperNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Stepper.class);
		register(StepNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Step.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.TextExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.HomeTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.ActionableExamplesMold.class);
		register(BaseNumberNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseNumber.class);
		register(NumberNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Number.class);
		register(NumberEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.NumberEditable.class);
		register(BaseDateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseDate.class);
		register(DateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Date.class);
		register(DateEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.DateEditable.class);
		register(BaseTextNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseText.class);
		register(TextNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Text.class);
		register(TextCodeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextCode.class);
		register(TextEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextEditable.class);
		register(TextEditableCodeNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.TextEditableCode.class);
		register(BaseFileNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseFile.class);
		register(FileNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.File.class);
		register(FileEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.FileEditable.class);
		register(BaseImageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseImage.class);
		register(ImageNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Image.class);
		register(ImageAvatarNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ImageAvatar.class);
		register(ImageEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.ImageEditable.class);
		register(BaseLocationNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.BaseLocation.class);
		register(LocationNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.Location.class);
		register(LocationEditableNotifier.class).forDisplay(io.intino.alexandria.ui.displays.components.LocationEditable.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MapExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MicroSiteExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.WidgetMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.PropertyMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MethodMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.MethodParamMold.class);
		register(EventsDisplayNotifier.class).forDisplay(io.intino.alexandria.ui.displays.EventsDisplay.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.StepperExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.alexandria.ui.displays.templates.DividerExamplesMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.GroupingToolbar1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DownloadSelectionMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DynFirstNameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.DynLastNameItem.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table11Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table12Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table21Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Table22Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Sorting1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Sorting2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Selector8ListMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Grouping1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Grouping2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.SearchBox1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List3Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List4Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.List5Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Dialog4ListMold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map1Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map2Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map3Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.alexandria.ui.displays.items.Map4Mold.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.Table1Row.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.Table2Row.class);
		register(io.intino.alexandria.ui.displays.notifiers.RowNotifier.class).forDisplay(io.intino.alexandria.ui.displays.rows.DynamicTable1Row.class);
	}
}