/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Range;
import io.intino.alexandria.ui.displays.components.AbstractDateEditable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.notifiers.DateEditableNotifier;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class DateEditable<DN extends DateEditableNotifier, B extends Box>
extends AbstractDateEditable<DN, B>
implements Editable<DN, B> {
    private Instant min;
    private Instant max;
    private Instant value;
    private boolean readonly;
    private ChangeListener changeListener = null;

    public DateEditable(B box) {
        super(box);
    }

    public Instant value() {
        return this.value;
    }

    public Instant min() {
        return this.min;
    }

    public DateEditable<DN, B> min(Instant min) {
        this._min(min);
        ((DateEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    public Instant max() {
        return this.max;
    }

    public DateEditable<DN, B> max(Instant max) {
        this._max(max);
        ((DateEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    public DateEditable<DN, B> range(Instant min, Instant max) {
        this._min(min);
        this._max(max);
        ((DateEditableNotifier)this.notifier).refreshRange(this.range());
        return this;
    }

    public DateEditable<DN, B> pattern(String pattern) {
        ((DateEditableNotifier)this.notifier).refreshPattern(pattern);
        return this;
    }

    public DateEditable<DN, B> views(List<View> views) {
        ((DateEditableNotifier)this.notifier).refreshViews(views.stream().map(Enum::name).collect(Collectors.toList()));
        return this;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((DateEditableNotifier)this.notifier).refresh(this.value());
    }

    @Override
    public DateEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        ((DateEditableNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public void value(Instant value) {
        this._value(value);
        ((DateEditableNotifier)this.notifier).refresh(value);
    }

    @Override
    public DateEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    public void notifyChange(Instant value) {
        this.value(value);
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    protected DateEditable<DN, B> _value(Instant value) {
        this.value = value;
        return this;
    }

    protected DateEditable<DN, B> _min(Instant min) {
        this.min = min;
        return this;
    }

    protected DateEditable<DN, B> _max(Instant max) {
        this.max = max;
        return this;
    }

    protected DateEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    private Range range() {
        Range range = new Range();
        if (this.min != null) {
            range.min(this.min.toEpochMilli());
        }
        if (this.max != null) {
            range.max(this.max.toEpochMilli());
        }
        return range;
    }

    public static enum View {
        Year,
        Date,
        Month;

    }
}

