/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractBlockDrawer;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.events.actionable.ToggleListener;
import io.intino.alexandria.ui.displays.notifiers.BlockDrawerNotifier;
import java.util.ArrayList;
import java.util.List;

public class BlockDrawer<DN extends BlockDrawerNotifier, B extends Box>
extends AbstractBlockDrawer<B> {
    private boolean opened = false;
    private List<ToggleListener> toggleListeners = new ArrayList<ToggleListener>();

    public BlockDrawer(B box) {
        super(box);
    }

    public BlockDrawer onToggle(ToggleListener listener) {
        this.toggleListeners.add(listener);
        return this;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public BlockDrawer open() {
        this.update(true);
        return this;
    }

    public BlockDrawer close() {
        this.update(false);
        return this;
    }

    public BlockDrawer toggle() {
        this.update(!this.opened);
        return this;
    }

    private void update(boolean value) {
        this.opened = value;
        this.notifyToggle();
    }

    private void notifyToggle() {
        ((BlockDrawerNotifier)this.notifier).refresh(this.opened);
        this.toggleListeners.forEach(l -> l.accept(new ToggleEvent((Display)this, this.opened)));
        this.updateVisibility(this.opened);
    }
}

