/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.PropertyList;
import io.intino.alexandria.ui.displays.components.AbstractBaseSelector;
import io.intino.alexandria.ui.displays.components.BaseText;
import io.intino.alexandria.ui.displays.components.Divider;
import io.intino.alexandria.ui.displays.components.addressable.Addressable;
import io.intino.alexandria.ui.displays.components.selector.Selector;
import io.intino.alexandria.ui.displays.components.selector.SelectorOption;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.notifiers.BaseSelectorNotifier;
import io.intino.alexandria.ui.displays.notifiers.TextNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class BaseSelector<DN extends BaseSelectorNotifier, B extends Box>
extends AbstractBaseSelector<DN, B>
implements Selector,
Addressable {
    private boolean readonly;
    private boolean multipleSelection = false;
    private String path;
    private String address;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private List<Component> components = new ArrayList<Component>();

    public BaseSelector(B box) {
        super(box);
    }

    @Override
    public BaseSelector<DN, B> onSelect(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
        return this;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public BaseSelector<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        ((BaseSelectorNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    @Override
    public void init() {
        super.init();
        if (this.validAddress()) {
            ((BaseSelectorNotifier)this.notifier).addressed(this.address);
        }
    }

    @Override
    public void didMount() {
        super.didMount();
        this.reloadComponents();
        if (this.validAddress()) {
            ((BaseSelectorNotifier)this.notifier).addressed(this.address);
        }
    }

    @Override
    public List<SelectorOption> options() {
        return this.findOptions();
    }

    @Override
    public BaseSelector<DN, B> add(String option) {
        Object display = new Text((Box)this.box()).name(option);
        ((Display)display).id(UUID.randomUUID().toString());
        ((Display)display).properties().put("value", option);
        ((Display)display).properties().put("color", "black");
        this.addOption((Component)display);
        return this;
    }

    @Override
    public void add(SelectorOption option) {
        this.addOption((Component)((Object)option));
    }

    @Override
    public <D extends Display> D add(D child) {
        return this.addOption((Component)child);
    }

    @Override
    public void clear() {
        super.clear();
        this.components.clear();
    }

    @Override
    public void addDivider() {
        Divider divider = new Divider(this.box());
        PropertyList properties = divider.properties();
        properties.addClassName("divider");
        super.add(divider);
    }

    public void optionsRendered() {
        this.children().forEach(Display::update);
    }

    @Override
    public String path() {
        return this.path;
    }

    public boolean multipleSelection() {
        return this.multipleSelection;
    }

    protected List<Component> components() {
        return this.components;
    }

    protected BaseSelector<DN, B> components(List<Component> components) {
        this.components = components;
        return this;
    }

    protected void reloadComponents() {
        ArrayList<Component> components = new ArrayList<Component>(this.components.size() > 0 ? this.components : this.children(Component.class));
        this.clear();
        this.components = new ArrayList<Component>();
        components.forEach(this::add);
    }

    protected BaseSelector<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    protected BaseSelector<DN, B> _multipleSelection(boolean value) {
        this.multipleSelection = value;
        return this;
    }

    protected void notifySelection(List selection) {
        this.selectionListeners.parallelStream().forEach(l -> l.accept(new SelectionEvent(this, selection)));
    }

    protected void notifySelection() {
        this.selectionListeners.parallelStream().forEach(l -> l.accept(new SelectionEvent(this, this.selection())));
    }

    protected BaseSelector<DN, B> _path(String path) {
        this.path = path;
        this._address(path);
        return this;
    }

    protected BaseSelector<DN, B> _address(String address) {
        this.address = address;
        return this;
    }

    protected void address(String value) {
        this._address(value);
        ((BaseSelectorNotifier)this.notifier).addressed(this.address);
    }

    String nameOf(String label) {
        if (label == null) {
            return null;
        }
        int position = this.position(label);
        if (position == -1) {
            return null;
        }
        return this.nameOf(position);
    }

    String nameOf(int option) {
        if (option == -1) {
            return null;
        }
        SelectorOption child = this.findOption(option);
        return child != null ? child.name() : null;
    }

    SelectorOption findOption(int option) {
        if (option < 0) {
            return null;
        }
        List<SelectorOption> options = this.options();
        int size = options.size();
        return size > 0 && option < size ? options.get(option) : null;
    }

    int position(String option) {
        List<SelectorOption> options = this.options();
        for (int i = 0; i < options.size(); ++i) {
            SelectorOption selectorOption = options.get(i);
            if (!selectorOption.name().equalsIgnoreCase(option) && !selectorOption.id().equals(option) && (!(selectorOption instanceof BaseText) || !((BaseText)((Object)selectorOption)).value().equals(option))) continue;
            return i;
        }
        return -1;
    }

    private List<SelectorOption> findOptions() {
        ArrayList<SelectorOption> result = new ArrayList<SelectorOption>();
        List<Component> children = this.children(Component.class);
        children.forEach(c -> result.addAll(this.findOptions((Component)c)));
        return result;
    }

    private List<SelectorOption> findOptions(Component child) {
        ArrayList<SelectorOption> result = new ArrayList<SelectorOption>();
        if (child instanceof SelectorOption) {
            result.add((SelectorOption)((Object)child));
        }
        List<Component> children = child.children(Component.class);
        children.forEach(c -> result.addAll(this.findOptions((Component)c)));
        return result;
    }

    private <D extends Display> D addOption(Component option) {
        this.components.add(option);
        PropertyList properties = option.properties();
        properties.addClassName("option");
        properties.put("id", option.id());
        properties.put("name", option.name());
        properties.put("label", option.label());
        return (D)super.add(option);
    }

    private boolean validAddress() {
        return this.address != null && this.address.chars().filter(c -> c == 58).count() <= 1L;
    }

    private static class Text
    extends io.intino.alexandria.ui.displays.components.Text<TextNotifier, Box>
    implements SelectorOption {
        public Text(Box box) {
            super(box);
        }
    }
}

