/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.schemas.DynamicTableRowParams;
import io.intino.alexandria.schemas.DynamicTableSetup;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractDynamicTable;
import io.intino.alexandria.ui.displays.components.Row;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.DynamicTableCollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.builders.DynamicTableBuilder;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.collection.SelectRowEvent;
import io.intino.alexandria.ui.displays.events.collection.SelectRowListener;
import io.intino.alexandria.ui.displays.notifiers.DynamicTableNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.DynamicTableDatasource;
import io.intino.alexandria.ui.model.dynamictable.Section;
import java.util.List;
import java.util.stream.Collectors;

public abstract class DynamicTable<B extends Box, ItemComponent extends Row, Item>
extends AbstractDynamicTable<DynamicTableNotifier, B>
implements Collection<ItemComponent, Item> {
    private SelectRowListener selectRowListener;

    public DynamicTable(B box) {
        super(box);
    }

    @Override
    public void source(Datasource source) {
        this.source(source, new DynamicTableCollectionBehavior(this));
    }

    public String dimension() {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return null;
        }
        return behavior.dimension();
    }

    public DynamicTable dimension(String dimension) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return this;
        }
        behavior.dimension(dimension);
        return this;
    }

    public String drill() {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return null;
        }
        return behavior.drill();
    }

    public DynamicTable drill(String drill) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        if (behavior == null) {
            return this;
        }
        behavior.drill(drill);
        return this;
    }

    public DynamicTable onSelectRow(SelectRowListener listener) {
        this.selectRowListener = listener;
        return this;
    }

    @Override
    protected AddItemEvent itemEvent(Display display, int index) {
        return new AddItemEvent(this, (Row)display, ((Row)display).item(), index);
    }

    @Override
    public void loadMoreItems(CollectionMoreItems info) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.moreItems(info);
    }

    @Override
    public void changePage(Integer page) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.page(page);
        ((DynamicTableNotifier)this.notifier).refresh();
    }

    @Override
    public void changePageSize(Integer size) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.pageSize(size);
        ((DynamicTableNotifier)this.notifier).refresh();
    }

    @Override
    public ItemComponent add(Item item) {
        Row component = (Row)this.create(item);
        this.addPromise(component, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> add(List<Item> items) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.addPromise(components, "rows");
        return components;
    }

    @Override
    public ItemComponent insert(Item item, int index) {
        Row component = (Row)this.create(item);
        this.insertPromise(component, index, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> insert(List<Item> items, int from) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.insertPromise(components, from, "rows");
        return components;
    }

    public void refreshSections(List<Section> sections) {
        ((DynamicTableNotifier)this.notifier).sections(DynamicTableBuilder.buildList(sections, this.language()));
        ((DynamicTableNotifier)this.notifier).selectRowProvided(this.selectRowListener != null);
    }

    public void selectRow(DynamicTableRowParams params) {
        if (this.selectRowListener == null) {
            return;
        }
        SelectRowEvent event = new SelectRowEvent(this, this.sectionOf(params.section()), params.row());
        ((DynamicTableNotifier)this.notifier).openRow(this.selectRowListener.accept(event));
    }

    public void showItems(DynamicTableRowParams params) {
        Section section = this.sectionOf(params.section());
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.section(section);
        behavior.row(params.row());
        behavior.reload();
        ((DynamicTableNotifier)this.notifier).setup(new DynamicTableSetup().openRowExternal(this.selectRowListener != null).pageSize(this.pageSize()).itemCount(behavior.itemCount()));
    }

    private Section sectionOf(String section) {
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        List<Section> sections = behavior.sections();
        return sections.stream().filter((? super T s) -> s.label().equals(section)).findFirst().orElse(null);
    }

    @Override
    void setup() {
        DynamicTableDatasource source = (DynamicTableDatasource)this.source();
        if (source == null) {
            return;
        }
        DynamicTableCollectionBehavior behavior = (DynamicTableCollectionBehavior)this.behavior();
        behavior.setup(source, this.pageSize());
        ((DynamicTableNotifier)this.notifier).setup(new DynamicTableSetup().openRowExternal(this.selectRowListener != null).pageSize(this.pageSize()).itemCount(behavior.itemCount()));
        this.notifyReady();
    }
}

