/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui;

import io.intino.alexandria.ui.displays.Desktop;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.DisplayRepository;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import io.intino.alexandria.ui.utils.UUIDUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class Soul
implements DisplayRepository {
    private final Map<String, Display> displays = new HashMap<String, Display>();
    private final List<Consumer<Display>> registerListeners = new ArrayList<Consumer<Display>>();
    private Consumer<String> redirectListener = null;
    protected final UISession session;
    protected User user;

    public Soul(UISession session) {
        this.session = session;
    }

    public abstract void personify();

    public UISession session() {
        return this.session;
    }

    public User user() {
        return this.session != null ? this.session.user() : null;
    }

    public void destroy() {
        new ArrayList<Display>(this.displays.values()).stream().filter(Objects::nonNull).forEach(Display::remove);
        this.displays.clear();
    }

    public void onRedirect(Consumer<String> listener) {
        this.redirectListener = listener;
    }

    public void redirect(String url) {
        if (this.redirectListener == null) {
            return;
        }
        this.redirectListener.accept(url);
    }

    public URL baseAssetUrl() {
        try {
            return new URL(this.session.browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public <T extends Display> List<T> displays(Class<T> clazz) {
        return new ArrayList<Display>(this.displays.values()).stream().filter(c -> clazz.isAssignableFrom(c.getClass())).map(clazz::cast).collect(Collectors.toList());
    }

    public <T extends Display> T display(Class<T> clazz) {
        List<T> displays = this.displays(clazz);
        return (T)(displays.size() > 0 ? (Display)displays.get(0) : null);
    }

    public <T extends Display> T displayWithId(String owner, String context, String id) {
        Display display = this.findDisplay(owner, context, id);
        if (display != null) {
            return (T)display;
        }
        String ownerId = owner != null && !owner.isEmpty() ? owner : "";
        Object key = ownerId + id;
        if (!this.displays.containsKey(key)) {
            key = id;
        }
        return (T)(this.displays.containsKey(key) ? this.displays.get(key) : null);
    }

    public <T extends Desktop> T desktop() {
        return (T)((Desktop)this.displays.values().stream().filter(d -> d instanceof Desktop).findFirst().orElse(null));
    }

    @Override
    public List<Display> getAll() {
        return new ArrayList<Display>(this.displays.values());
    }

    @Override
    public <T extends Display> T get(String id) {
        return (T)this.displays.get(id);
    }

    @Override
    public <T extends Display> void register(T display) {
        String ownerId = display.owner() != null ? display.owner().id() : "";
        String context = display.owner() != null ? display.owner().path() : "";
        this.displays.put(ownerId + display.id(), display);
        this.displays.put(context + display.id(), display);
        if (UUIDUtil.isUUID(display.id())) {
            this.displays.put(display.id(), display);
        }
        this.registerListeners.forEach(listener -> listener.accept(display));
    }

    @Override
    public void addRegisterDisplayListener(Consumer<Display> consumer) {
        this.registerListeners.add(consumer);
    }

    @Override
    public void remove(String id) {
        this.displays.remove(id);
    }

    private Display findDisplay(String owner, String context, String id) {
        ArrayList contextList = context != null && !context.isEmpty() ? Arrays.asList(context.split("\\.")) : new ArrayList();
        List result = this.displays.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return key.endsWith(owner + id) && (((Display)e.getValue()).owner() == null || this.containsAll(contextList, ((Display)e.getValue()).owner().path()));
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        return result.size() > 0 ? (Display)result.get(0) : null;
    }

    private boolean containsAll(List<String> contextList, String owner) {
        List ownerList;
        List<Object> list = ownerList = owner != null ? Arrays.asList(owner.split("\\.")) : Collections.emptyList();
        if (ownerList.size() > 0 && ownerList.size() < contextList.size()) {
            return contextList.containsAll(ownerList);
        }
        return ownerList.containsAll(contextList);
    }
}

