package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Map;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class MapRequester extends CollectionRequester {

	public MapRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Map display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("showPlaceMark")) {
			display.showPlaceMark(Long.parseLong(manager.fromQuery("v")));
			return;
		}

		super.execute();
	}
}