/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.dynamictable;

import io.intino.alexandria.ui.model.dynamictable.Cell;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Section {
    private String label;
    private String color;
    private String backgroundColor;
    private int fontSize;
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rowList = new ArrayList<Row>();
    private List<Section> sectionList = new ArrayList<Section>();

    public Section(String label) {
        this(label, "black", "#efefef", 12);
    }

    public Section(String label, String color, String backgroundColor, int fontSizeInPt) {
        this.label = label;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSizeInPt;
    }

    public String label() {
        return this.label;
    }

    public Section label(String label) {
        this.label = label;
        return this;
    }

    public String color() {
        return this.color;
    }

    public Section color(String color) {
        this.color = color;
        return this;
    }

    public String backgroundColor() {
        return this.backgroundColor;
    }

    public Section backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public Section fontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public List<Row> rows() {
        return this.rowList;
    }

    public List<Column> columns() {
        return this.columns;
    }

    public Section columns(String ... columns) {
        this.columns(Arrays.stream(columns).map(c -> new Column((String)c, Column.Operator.Sum)).collect(Collectors.toList()));
        return this;
    }

    public Section columns(List<Column> columnList) {
        this.columns = columnList;
        return this;
    }

    public Column column(String label) {
        return this.columns.stream().filter(c -> c.label().equals(label)).findFirst().orElse(null);
    }

    public Section add(String rowLabel, List<Double> values) {
        return this.add(rowLabel, values.stream().mapToDouble(v -> v).toArray());
    }

    public Section add(String rowLabel, double ... values) {
        Row row = new Row(rowLabel);
        if (this.columns.size() != values.length) {
            throw new NumberFormatException("Columns and value size must be equal");
        }
        for (int i = 0; i < values.length; ++i) {
            row.add(new Cell(this.columns.get(i).label(), values[i]));
        }
        this.rowList.add(row);
        return this;
    }

    public Section add(Row row) {
        this.rowList.add(row);
        return this;
    }

    public List<Section> sections() {
        return this.sectionList;
    }

    public Section add(String label) {
        return this.add(new Section(label));
    }

    public Section add(String label, String color, String backgroundColor, int fontSize) {
        return this.add(new Section(label, color, backgroundColor, fontSize));
    }

    public Section add(Section section) {
        this.sectionList.add(section);
        return section;
    }
}

