/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractMultiple;
import io.intino.alexandria.ui.displays.components.collection.Selectable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.ChangeItemEvent;
import io.intino.alexandria.ui.displays.events.RemoveItemEvent;
import io.intino.alexandria.ui.displays.events.editable.AddItemListener;
import io.intino.alexandria.ui.displays.events.editable.ChangeItemListener;
import io.intino.alexandria.ui.displays.events.editable.RemoveItemListener;
import io.intino.alexandria.ui.displays.notifiers.MultipleNotifier;
import java.util.List;

public abstract class Multiple<B extends Box, C extends Component, V>
extends AbstractMultiple<B> {
    private boolean readonly;
    private AddItemListener addItemListener;
    private ChangeItemListener changeItemListener;
    private RemoveItemListener removeItemListener;

    public Multiple(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        ((MultipleNotifier)this.notifier).refreshVisibility(this.visible());
    }

    public void addAll(List<V> values) {
        values.forEach(this::add);
    }

    public boolean readonly() {
        return this.readonly;
    }

    public Multiple<B, C, V> readonly(boolean readonly) {
        this._readonly(readonly);
        ((MultipleNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public C add() {
        return this.add((V)null);
    }

    @Override
    public abstract C add(V var1);

    public abstract void remove(C var1);

    public void remove(int index) {
        List<Display> children = this.children();
        if (children.size() <= index) {
            return;
        }
        this.notifyRemove(index);
        this.remove((Component)children.get(index));
        this.children().stream().filter(d -> d instanceof Editable).forEach(d -> ((Editable)((Object)d)).reload());
    }

    protected Multiple<B, C, V> notifyAdd(C child) {
        this.notifyAdd(child, null);
        return this;
    }

    protected Multiple<B, C, V> _readonly(boolean readonly) {
        this.readonly = readonly;
        this.children().stream().filter(c -> c instanceof Editable).forEach(c -> this._readonly((Display)c, readonly));
        return this;
    }

    protected Multiple<B, C, V> addItemListener(AddItemListener listener) {
        this.addItemListener = listener;
        return this;
    }

    protected Multiple<B, C, V> changeItemListener(ChangeItemListener listener) {
        this.changeItemListener = listener;
        return this;
    }

    protected Multiple<B, C, V> removeItemListener(RemoveItemListener listener) {
        this.removeItemListener = listener;
        return this;
    }

    protected Multiple<B, C, V> notifyAdd(C child, V value) {
        int index = this.children().size() - 1;
        if (this.addItemListener != null) {
            this.addItemListener.accept(new AddItemEvent(this, (Component)child, value, index));
        }
        this.addListeners(child, value, index);
        this._readonly((Display)child, this.readonly);
        return this;
    }

    protected Multiple<B, C, V> notifyRemove(int index) {
        if (this.removeItemListener != null) {
            this.removeItemListener.accept(new RemoveItemEvent(this, index));
        }
        return this;
    }

    private void addListeners(C child, V value, int index) {
        this.addSelectListener(child, value, index);
        this.addChangeListener(child, value, index);
    }

    private void addSelectListener(C child, V value, int index) {
        if (!(child instanceof Selectable)) {
            return;
        }
        ((Selectable)child).onSelect(e -> this.notifySelect(child, e.selection(), index));
    }

    private void addChangeListener(C child, V value, int index) {
        if (!(child instanceof Editable)) {
            return;
        }
        ((Editable)child).onChange(e -> this.notifyChange(child, e.value(), index));
    }

    private void notifySelect(C child, List<V> selection, int index) {
        if (this.changeItemListener == null) {
            return;
        }
        this.changeItemListener.accept(new ChangeItemEvent(this, (Component)child, selection, index));
    }

    private void notifyChange(C child, V value, int index) {
        if (this.changeItemListener == null) {
            return;
        }
        this.changeItemListener.accept(new ChangeItemEvent(this, (Component)child, value, index));
    }

    private void _readonly(Display c, boolean readonly) {
        if (!(c instanceof Editable)) {
            return;
        }
        ((Editable)((Object)c)).readonly(readonly);
    }
}

