/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.Verifier;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.spark.AuthenticateCallbackAction;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.Resource;
import java.util.Optional;

public class AuthenticateCallbackResource
extends Resource {
    public AuthenticateCallbackResource(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        super.execute();
        AuthenticateCallbackAction action = new AuthenticateCallbackAction();
        action.session = this.manager.currentSession();
        try {
            this.verifyAccessToken();
            this.listenForLogOut(action);
            UserInfo info = this.userInfo();
            if (info != null) {
                action.whenLoggedIn(this.userOf(info));
            }
            this.manager.redirect(this.manager.baseUrl() + this.manager.userHomePath() + "?authId=" + this.manager.fromQuery("authId"));
        }
        catch (CouldNotObtainAccessToken error) {
            this.manager.write(error);
        }
    }

    private void verifyAccessToken() throws CouldNotObtainAccessToken {
        Optional<AuthService.Authentication> authentication = this.authenticationOf(this.manager.currentSession(), this.manager.fromQuery("authId"));
        if (!authentication.isPresent()) {
            return;
        }
        String oauthVerifier = this.manager.fromQuery("oauth_verifier");
        if (oauthVerifier == null) {
            oauthVerifier = this.manager.fromQuery("code");
        }
        Token accessToken = authentication.get().accessToken(Verifier.build(oauthVerifier));
        this.manager.currentSession().token(accessToken);
    }

    private void listenForLogOut(AuthenticateCallbackAction action) {
        try {
            Token accessToken = this.accessToken();
            if (accessToken == null) {
                return;
            }
            this.authService().addPushListener(accessToken, this.pushListener(action));
        }
        catch (CouldNotObtainInfo error) {
            error.printStackTrace();
        }
    }

    @Override
    protected Token accessToken() {
        AuthService.Authentication authentication = this.authentication().orElse(null);
        return authentication != null ? authentication.accessToken() : null;
    }

    private AuthService.FederationNotificationListener pushListener(final AuthenticateCallbackAction action) {
        return new AuthService.FederationNotificationListener(){

            @Override
            public void userLoggedOut(UserInfo userInfo) {
                action.whenLoggedOut(AuthenticateCallbackResource.this.userOf(userInfo));
            }

            @Override
            public void userAdded(UserInfo userInfo) {
            }
        };
    }

    private UserInfo userInfo() {
        try {
            Token accessToken = this.accessToken();
            return accessToken != null ? this.authService().me(accessToken) : null;
        }
        catch (CouldNotObtainInfo error) {
            Logger.debug((String)error.getMessage());
            return null;
        }
    }
}

