/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractTable;
import io.intino.alexandria.ui.displays.components.Row;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.PageCollectionBehavior;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.notifiers.TableNotifier;
import io.intino.alexandria.ui.model.Datasource;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Table<B extends Box, ItemComponent extends Row, Item>
extends AbstractTable<TableNotifier, B>
implements Collection<ItemComponent, Item> {
    public Table(B box) {
        super(box);
    }

    @Override
    public <D extends Datasource> void source(D source) {
        this.source(source, new PageCollectionBehavior(this));
    }

    @Override
    protected AddItemEvent itemEvent(Display display, int index) {
        return new AddItemEvent(this, (Row)display, ((Row)display).item(), index);
    }

    @Override
    public ItemComponent add(Item item) {
        Row component = (Row)this.create(item);
        this.addPromise(component, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> add(List<Item> items) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.addPromise(components, "rows");
        return components;
    }

    @Override
    public ItemComponent insert(Item item, int index) {
        Row component = (Row)this.create(item);
        this.insertPromise(component, index, "rows");
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> insert(List<Item> items, int from) {
        List components = items.stream().map(this::create).collect(Collectors.toList());
        this.insertPromise(components, from, "rows");
        return components;
    }
}

