/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.components.AbstractSelectorCollectionBox;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.collection.Selectable;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.notifiers.SelectorCollectionBoxNotifier;
import io.intino.alexandria.ui.model.Datasource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class SelectorCollectionBox<DN extends SelectorCollectionBoxNotifier, B extends Box>
extends AbstractSelectorCollectionBox<DN, B> {
    private List<Object> selection = new ArrayList<Object>();
    private Collection collection;
    private ValueProvider valueProvider;

    public SelectorCollectionBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.selection(this.selection);
    }

    public List<Object> selection() {
        return this.selection;
    }

    public SelectorCollectionBox<DN, B> multipleSelection(boolean multipleSelection) {
        this._multipleSelection(multipleSelection);
        ((SelectorCollectionBoxNotifier)this.notifier).refreshMultipleSelection(multipleSelection);
        return this;
    }

    public SelectorCollectionBox<DN, B> source(Datasource source) {
        this.collection.source(source);
        return this;
    }

    public void addAndBindTo(Selectable collection) {
        this.add((Collection)((Object)collection), "__elements");
        this.bindTo(collection);
    }

    public void bindTo(Selectable collection) {
        this.collection = (Collection)((Object)collection);
        this.collection().ifPresent(c -> collection.onSelect(event -> {
            this.updateSelection(event);
            if (this.multipleSelection()) {
                ((Collection)((Object)collection)).reload();
            } else {
                ((SelectorCollectionBoxNotifier)this.notifier).close();
            }
        }));
    }

    public SelectorCollectionBox<DN, B> valueProvider(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
        return this;
    }

    public void search(String value) {
        this.collection.filter(value);
    }

    public void selection(String ... selection) {
        this.selection(Arrays.asList(selection));
    }

    @Override
    public void init() {
        super.init();
        this.collection().ifPresent(Collection::init);
    }

    @Override
    public void reset() {
        this.select(new String[0]);
    }

    public void opened() {
        this.collection().ifPresent(Collection::reload);
    }

    public <T> void selection(T ... selection) {
        this.selection(Arrays.asList(selection));
    }

    public <T> void selection(List<T> selection) {
        this.selection = new ArrayList<T>(selection);
        ((SelectorCollectionBoxNotifier)this.notifier).refreshSelection(this.selection.stream().map(this::valueOf).collect(Collectors.toList()));
    }

    public void select(String ... options) {
        this.updateSelection(Arrays.asList(options));
    }

    public void clearSelection() {
        this.updateSelection(new ArrayList());
    }

    public void unSelect(String option) {
        this.updateSelection(this.selection.stream().filter(i -> !option.equals(this.valueOf(i))).collect(Collectors.toList()));
        this.collection.reload();
    }

    @Override
    protected void reloadComponents() {
        ArrayList<Component> components = new ArrayList<Component>(this.components().size() > 0 ? this.components() : Collections.emptyList());
        this.clear();
        this.components(new ArrayList<Component>());
        components.forEach(this::add);
    }

    private void updateSelection(SelectionEvent event) {
        Object selected;
        Object e = selected = event.selection().size() > 0 ? (Object)event.selection().get(0) : null;
        if (this.multipleSelection()) {
            if (selected == null) {
                return;
            }
            boolean found = this.selection.stream().anyMatch(i -> this.valueOf(selected).equals(this.valueOf(i)));
            if (found) {
                this.selection = this.selection.stream().filter(i -> !this.valueOf(selected).equals(this.valueOf(i))).collect(Collectors.toList());
            } else {
                this.selection.add(selected);
            }
        } else {
            this.selection = selected != null ? Collections.singletonList(selected) : Collections.emptyList();
        }
        this.updateSelection(this.selection);
    }

    private <T> void updateSelection(List<T> options) {
        this.selection(options);
        this.notifySelection(this.selection);
    }

    private String valueOf(Object selected) {
        if (selected == null) {
            return null;
        }
        return this.valueProvider != null ? this.valueProvider.valueOf(selected) : this.translate("Inject value provider to selector");
    }

    private Optional<Collection> collection() {
        return Optional.ofNullable(this.collection);
    }

    public static interface ValueProvider {
        public String valueOf(Object var1);
    }
}

