/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.AbstractDownload;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.actionable.DownloadEvent;
import io.intino.alexandria.ui.displays.events.actionable.DownloadListener;
import io.intino.alexandria.ui.displays.notifiers.DownloadNotifier;
import io.intino.alexandria.ui.spark.UIFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;

public class Download<DN extends DownloadNotifier, B extends Box>
extends AbstractDownload<DN, B> {
    private String option = null;
    private List<String> options;
    private Collection collection;
    private Formatter formatter;
    private DownloadListener downloadListener;
    private static final String DefaultSeparator = "\t";
    private static final String LineSeparator = "\n";
    private static final String DefaultExtension = ".txt";

    public Download(B box) {
        super(box);
    }

    public List<String> options() {
        return this.options;
    }

    public Download<DN, B> bindTo(Collection collection) {
        this.collection = collection;
        return this;
    }

    public Download<DN, B> formatter(Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public void changeParams(String option) {
        this.option = option;
    }

    public void onExecute(DownloadListener listener) {
        this.downloadListener = listener;
    }

    public UIFile execute() {
        if (this.collection != null) {
            return this.executeDownloadCollection();
        }
        if (this.downloadListener == null) {
            return this.defaultFile();
        }
        return this.downloadListener.accept(new DownloadEvent(this, this.option));
    }

    protected Download<DN, B> _options(List<String> options) {
        this.options = options;
        return this;
    }

    protected Download<DN, B> _select(String option) {
        this.option = option;
        return this;
    }

    private UIFile executeDownloadCollection() {
        if (this.formatter == null) {
            this.notifyUser(this.translate("You must implement formatter for downloading collections"), UserMessage.Type.Error);
            return this.defaultFile();
        }
        this.notifyUser(this.translate("Downloading. It might take a few minutes, please, wait..."), UserMessage.Type.Loading);
        return new UIFile(){

            @Override
            public String label() {
                return Download.this.formatter.filename() != null ? Download.this.formatter.filename() : Download.this.downloadDate() + Download.DefaultExtension;
            }

            @Override
            public InputStream content() {
                String content = Download.this.serializeEntries();
                Download.this.notifyUser(Download.this.translate("Downloaded"), UserMessage.Type.Success);
                return new ByteArrayInputStream(content.getBytes());
            }
        };
    }

    private String serializeEntries() {
        StringBuilder result = new StringBuilder();
        String separator = this.formatter.separator() != null ? this.formatter.separator() : DefaultSeparator;
        this.collection.items(this.formatter.sortings()).forEach(item -> result.append(this.serializeEntry(item, separator)));
        return result.toString();
    }

    private String serializeEntry(Object item, String separator) {
        StringBuilder result = new StringBuilder();
        this.formatter.columns(item).forEach(c -> result.append(c).append(separator));
        result.append(LineSeparator);
        return result.toString();
    }

    private String downloadDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("YYYYMMdd");
        return formatter.format(new Date(Instant.now().toEpochMilli()));
    }

    public static interface Formatter<T> {
        public String filename();

        public List<String> columns(T var1);

        public String[] sortings();

        default public String separator() {
            return Download.DefaultSeparator;
        }
    }
}

