/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.ActionableInfo;
import io.intino.alexandria.schemas.ActionableSign;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.actionable.SignChecker;
import io.intino.alexandria.ui.displays.notifiers.ActionableNotifier;
import io.intino.alexandria.ui.resources.Asset;
import io.intino.alexandria.ui.spark.UIFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class Actionable<DN extends ActionableNotifier, B extends Box>
extends Component<DN, B> {
    private String title;
    private boolean readonly = false;
    private String icon;
    private Mode mode;
    private SignChecker signChecker;
    private String signReason;

    public Actionable(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.isResourceIcon()) {
            this.refreshIcon();
        }
    }

    public String title() {
        return this.title;
    }

    public Actionable<DN, B> title(String title) {
        this._title(title);
        this.refresh();
        return this;
    }

    public Actionable<DN, B> icon(String icon) {
        this._icon(icon);
        this.refreshIcon();
        return this;
    }

    public Actionable<DN, B> readonly(boolean readonly) {
        if (readonly) {
            this.disable();
        } else {
            this.enable();
        }
        return this;
    }

    public boolean disabled() {
        return this.readonly;
    }

    public Actionable<DN, B> affirmed(String text) {
        ((ActionableNotifier)this.notifier).refreshAffirmed(text);
        return this;
    }

    public Actionable<DN, B> enable() {
        this._readonly(false);
        ((ActionableNotifier)this.notifier).refreshReadonly(this.readonly);
        return this;
    }

    public Actionable<DN, B> disable() {
        this._readonly(true);
        ((ActionableNotifier)this.notifier).refreshReadonly(this.readonly);
        return this;
    }

    @Override
    public void refresh() {
        ActionableInfo info = new ActionableInfo().title(this.title()).disabled(this.disabled());
        ((ActionableNotifier)this.notifier).refresh(info);
    }

    public void notifyUser(String message) {
        this.notifyUser(message, UserMessage.Type.Info);
    }

    public void checkSign(ActionableSign info) {
        if (this.signChecker == null) {
            ((ActionableNotifier)this.notifier).checkSignResult(true);
        }
        ((ActionableNotifier)this.notifier).checkSignResult(this.signChecker.check(info.sign(), info.reason()));
        this.signReason = info.reason();
    }

    public String signReason() {
        return this.signReason;
    }

    @Override
    public void init() {
        super.init();
        if (this.isResourceIcon()) {
            this.refreshIcon();
        }
    }

    protected Actionable<DN, B> _title(String title) {
        this.title = title;
        return this;
    }

    protected Actionable<DN, B> _mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    protected Actionable<DN, B> _icon(String icon) {
        this.icon = icon;
        return this;
    }

    protected Actionable<DN, B> _readonly(boolean value) {
        this.readonly = value;
        return this;
    }

    protected Actionable<DN, B> _signChecker(SignChecker checker) {
        this.signChecker = checker;
        return this;
    }

    UIFile defaultFile() {
        return new UIFile(){

            @Override
            public String label() {
                return Actionable.this.title();
            }

            @Override
            public InputStream content() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }

    private void refreshIcon() {
        String icon = this.isResourceIcon() ? Asset.toResource(this.baseAssetUrl(), Actionable.class.getResource(this.icon)).toUrl().toString() : this.icon;
        ((ActionableNotifier)this.notifier).refreshIcon(icon);
    }

    private boolean isResourceIcon() {
        return (this.mode == Mode.IconButton || this.mode == Mode.IconToggle) && this.icon != null && Actionable.class.getResource(this.icon) != null;
    }

    public static enum Mode {
        Link,
        Button,
        IconButton,
        MaterialIconButton,
        Toggle,
        IconToggle,
        MaterialIconToggle,
        SplitButton,
        AvatarIconButton;

    }
}

