/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.microsite;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.microsite.MicroSiteBuilder;
import io.intino.alexandria.zip.Zip;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MicroSiteBuilderOfTsv
extends MicroSiteBuilder {
    private final Config config;
    private final Translator translator;
    private final Map<String, String> pages = new HashMap<String, String>();

    public MicroSiteBuilderOfTsv(Config config) {
        this(config, null);
    }

    public MicroSiteBuilderOfTsv(Config config, Translator translator) {
        this.config = config;
        this.translator = translator;
    }

    public void generate(File tsv, File out) {
        try {
            Zip zip = new Zip(out);
            this.pages.clear();
            long count = Files.lines(tsv.toPath()).count();
            Logger.info((String)("Generating site for " + tsv.getAbsolutePath() + ". Count pages: " + this.pageOf(count) + "1"));
            Stream<String> content = Files.lines(tsv.toPath());
            if (count == 0L) {
                return;
            }
            this.generatePages(content, count);
            this.addTsv(zip, tsv);
            zip.write(this.pages);
            Logger.info((String)("Site " + tsv.getAbsolutePath() + " generated"));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void addTsv(Zip zip, File tsv) throws IOException {
        zip.write("data.tsv", (InputStream)new FileInputStream(tsv), new StandardOpenOption[0]);
    }

    private void generatePages(Stream<String> lines, long count) {
        int countPages = this.pageOf(count) + 1;
        int currentPage = 0;
        int i = 0;
        StringBuilder collection = new StringBuilder();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int page = this.pageOf(i);
            if (page != currentPage) {
                this.generatePage(page - 1, countPages, collection);
                collection = new StringBuilder();
                ++currentPage;
            }
            collection.append(this.toRow((String)iterator.next()));
            ++i;
        }
        this.generatePage(countPages - 1, countPages, collection);
    }

    private void generatePage(int page, int countPages, StringBuilder collection) {
        String pageContent = this.pageContent(page + 1, countPages, collection);
        if (page == 0) {
            this.pages.put("index.html", pageContent);
        }
        this.pages.put(page + 1 + ".html", pageContent);
    }

    private String pageContent(int page, int countPages, StringBuilder collection) {
        String content = this.template();
        String options = IntStream.range(0, countPages).mapToObj(j -> "<option value='" + (j + 1) + "'" + (page == j + 1 ? " selected" : "") + ">" + this.translate("Page") + " " + (j + 1) + "</option>").collect(Collectors.joining());
        content = content.replace("::logo::", this.config.logo());
        content = content.replace("::title::", this.config.title());
        content = content.replace("::description::", this.config.description() != null ? this.config.description() : "");
        content = content.replace("::transactionHeader::", this.toHeaderRow(this.config.columns()));
        content = content.replace("::transactions::", collection);
        content = content.replace("::previousPage::", String.valueOf(page - 1));
        content = content.replace("::nextPage::", String.valueOf(page + 1));
        content = content.replace("::noTransactionsDisplay::", collection.length() > 0 ? "none" : "block");
        content = content.replace("::toolbarDisplay::", collection.length() > 0 ? "block" : "none");
        content = content.replace("::currentPage::", this.translate("Page") + " " + page + " " + this.translate("of") + " " + countPages);
        content = content.replace("::previousPageDisabled::", page == 1 ? "disabled" : "");
        content = content.replace("::nextPageDisabled::", page == countPages ? "disabled" : "");
        content = content.replace("::toolbarDisplay::", countPages > 1 ? "block" : "none");
        content = content.replace("::options::", options);
        content = content.replace("::before::", this.translate("Before"));
        content = content.replace("::next::", this.translate("Next"));
        return content;
    }

    private String translate(String word) {
        return this.translator != null ? this.translator.translate(word) : word;
    }

    private String toHeaderRow(List<Config.Column> columns) {
        return "<tr>" + columns.stream().map(c -> "<th>" + c.label + "</th>").collect(Collectors.joining()) + "</tr>";
    }

    private String toRow(String line) {
        String[] values = line.split("\t");
        return "<tr>" + this.config.columns().stream().map(c -> "<td>" + values[c.index] + "</td>").collect(Collectors.joining()) + "</tr>";
    }

    private int pageOf(long current) {
        if (current == 0L) {
            return 0;
        }
        if (this.config.pageSize == 0) {
            return 0;
        }
        return (int)(Math.floor((double)current / (double)this.config.pageSize) + (double)(current % (long)this.config.pageSize > 0L ? 1 : 0)) - 1;
    }

    public static interface Translator {
        public String translate(String var1);
    }

    public static class Config {
        private String title;
        private String logo;
        private String description;
        private int pageSize = 1000;
        private List<Column> columns = new ArrayList<Column>();

        public String title() {
            return this.title;
        }

        public Config title(String title) {
            this.title = title;
            return this;
        }

        public String logo() {
            return this.logo;
        }

        public Config logo(String logo) {
            this.logo = logo;
            return this;
        }

        public String description() {
            return this.description;
        }

        public Config description(String description) {
            this.description = description;
            return this;
        }

        public int pageSize() {
            return this.pageSize;
        }

        public Config pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public List<Column> columns() {
            return this.columns;
        }

        public Config add(Column column) {
            this.columns.add(column);
            return this;
        }

        public Config columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public static class Column {
            private String label;
            private int index;

            public Column(String label, int index) {
                this.label = label;
                this.index = index;
            }

            public String label() {
                return this.label;
            }

            public Column label(String label) {
                this.label = label;
                return this;
            }

            public int index() {
                return this.index;
            }

            public Column index(int index) {
                this.index = index;
                return this;
            }
        }
    }
}

