/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.builders;

import io.intino.alexandria.schemas.DynamicTableCell;
import io.intino.alexandria.schemas.DynamicTableColumn;
import io.intino.alexandria.schemas.DynamicTableRow;
import io.intino.alexandria.schemas.DynamicTableSection;
import io.intino.alexandria.ui.model.dynamictable.Cell;
import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Row;
import io.intino.alexandria.ui.model.dynamictable.Section;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DynamicTableBuilder {
    private static DecimalFormat df = new DecimalFormat("0.00");

    public static List<DynamicTableSection> buildList(List<Section> sections, String language) {
        return sections.stream().map(s -> DynamicTableBuilder.build(s, language)).collect(Collectors.toList());
    }

    public static DynamicTableSection build(Section section, String language) {
        DynamicTableSection result = new DynamicTableSection();
        result.label(section.label());
        result.color(section.color());
        result.backgroundColor(section.backgroundColor());
        result.fontSize(section.fontSize());
        result.columns(DynamicTableBuilder.buildColumnList(section));
        result.rows(DynamicTableBuilder.buildRowList(section.rows(), DynamicTableBuilder.calculateTotal(section, section.rows()), language));
        result.sections(DynamicTableBuilder.buildList(section.sections(), language));
        return result;
    }

    private static Map<String, Double> calculateTotal(Section section, List<Row> rows) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        rows.forEach(r -> r.cells().forEach(cell -> {
            if (!result.containsKey(cell.name())) {
                result.put(cell.name(), 0.0);
            }
            result.put(cell.name(), (Double)result.get(cell.name()) + cell.value());
        }));
        result.forEach((key, value) -> result.put((String)key, DynamicTableBuilder.calculateTotal(section.column((String)key), value, rows.size())));
        return result;
    }

    private static Double calculateTotal(Column column, Double value, int rowsCount) {
        if (column.operator() == Column.Operator.Average) {
            return rowsCount > 0 ? value / (double)rowsCount : 0.0;
        }
        return value;
    }

    private static List<DynamicTableRow> buildRowList(List<Row> rows, Map<String, Double> totalValues, String language) {
        List<DynamicTableRow> result = rows.stream().map(r -> DynamicTableBuilder.build(r, totalValues, language)).collect(Collectors.toList());
        if (result.size() <= 0) {
            return result;
        }
        result.add(DynamicTableBuilder.totalRow(rows, totalValues, language));
        return result;
    }

    private static DynamicTableRow totalRow(List<Row> rows, Map<String, Double> totalValues, String language) {
        DynamicTableRow row = new DynamicTableRow();
        row.label("Total");
        row.cells(rows.get(0).cells().stream().map(c -> DynamicTableBuilder.buildCell(c.name(), (Double)totalValues.get(c.name()), 100.0, language).highlighted(true)).collect(Collectors.toList()));
        row.isTotalRow(true);
        return row;
    }

    private static DynamicTableRow build(Row row, Map<String, Double> totalValues, String language) {
        DynamicTableRow result = new DynamicTableRow();
        result.label(row.label());
        result.cells(DynamicTableBuilder.buildCellList(row.cells(), totalValues, language));
        return result;
    }

    private static List<DynamicTableColumn> buildColumnList(Section section) {
        List<Row> rows = section.rows();
        if (rows.size() <= 0) {
            return Collections.emptyList();
        }
        return rows.get(0).cells().stream().map(c -> DynamicTableBuilder.build(c, section.column(c.name()))).collect(Collectors.toList());
    }

    private static DynamicTableColumn build(Cell cell, Column column) {
        return new DynamicTableColumn().label(column.label()).operator(DynamicTableBuilder.operatorOf(column.operator())).metric(column.metric());
    }

    private static DynamicTableColumn.Operator operatorOf(Column.Operator operator) {
        if (operator == Column.Operator.Average) {
            return DynamicTableColumn.Operator.Average;
        }
        return DynamicTableColumn.Operator.Sum;
    }

    private static List<DynamicTableCell> buildCellList(List<Cell> columns, Map<String, Double> totalValues, String language) {
        return columns.stream().map(c -> DynamicTableBuilder.buildCell(c, totalValues.getOrDefault(c.name(), 0.0), language)).collect(Collectors.toList());
    }

    private static DynamicTableCell buildCell(Cell column, Double total, String language) {
        return DynamicTableBuilder.buildCell(column.name(), column.value(), total != 0.0 ? DynamicTableBuilder.round(column.value() / total * 100.0, 2) : 0.0, language);
    }

    private static DynamicTableCell buildCell(String name, Double absolute, Double relative, String language) {
        DynamicTableCell result = new DynamicTableCell();
        result.label(name);
        result.absolute(absolute);
        result.relative(relative);
        return result;
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

