/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.behaviors;

import io.intino.alexandria.schemas.CollectionMoreItems;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.CollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.loaders.PageItemLoader;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import java.util.List;

public class PageCollectionBehavior<DS extends PageDatasource<Item>, Item>
extends CollectionBehavior<DS, Item, PageItemLoader<DS, Item>> {
    private int page = 0;
    public static final int DefaultPageSize = 20;

    public PageCollectionBehavior(Collection collection) {
        super(collection);
    }

    @Override
    public CollectionBehavior setup(DS source) {
        return this.setup(source, 20);
    }

    public CollectionBehavior setup(DS source, int pageSize) {
        if (source == null) {
            return this;
        }
        this.computeUpdate(e -> {
            this.itemLoader = new PageItemLoader((PageDatasource)source, pageSize);
            this.page(0);
        }, false);
        return this;
    }

    public void page(int pos) {
        this.computeUpdate(e -> {
            this.page = pos;
        });
    }

    public void pageSize(int size) {
        this.computeUpdate(e -> {
            PageItemLoader itemLoader = (PageItemLoader)this.itemLoader();
            itemLoader.pageSize(size);
        });
    }

    public synchronized void moreItems(CollectionMoreItems info) {
        List items = ((PageItemLoader)this.itemLoader).moreItems(info.start(), info.stop());
        this.collection().insert(items, info.start());
    }

    @Override
    public long itemCount() {
        return ((PageItemLoader)this.itemLoader).itemCount();
    }

    @Override
    protected void update() {
        PageItemLoader itemLoader = (PageItemLoader)this.itemLoader();
        int count = itemLoader.pageCount();
        while (this.page > count && this.page > 0) {
            --this.page;
        }
        if (count == 0) {
            return;
        }
        this.collection().add(itemLoader.page(this.page));
    }
}

