/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.AbstractMicroSite;
import io.intino.alexandria.ui.displays.notifiers.MicroSiteNotifier;
import io.intino.alexandria.ui.spark.UIFile;
import io.intino.alexandria.zip.Zip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.NoSuchFileException;

public class MicroSite<DN extends MicroSiteNotifier, B extends Box>
extends AbstractMicroSite<B> {
    private File site;
    private Zip siteReader;
    private int page = 0;

    public MicroSite(B box) {
        super(box);
    }

    public MicroSite<DN, B> site(File site) {
        this._site(site);
        return this;
    }

    public MicroSite<DN, B> page(String page) {
        this.page(this.normalize(page));
        return this;
    }

    public MicroSite<DN, B> page(int page) {
        this.page = page;
        return this;
    }

    @Override
    public void init() {
        super.init();
        if (this.site != null) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.renderPage();
    }

    public UIFile download() {
        return new UIFile(){

            @Override
            public String label() {
                return MicroSite.this.site.getName();
            }

            @Override
            public InputStream content() {
                try {
                    return new FileInputStream(MicroSite.this.site);
                }
                catch (FileNotFoundException e) {
                    Logger.error((Throwable)e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
    }

    protected MicroSite<DN, B> _site(URL site) {
        try {
            this._site(new File(site.toURI()));
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e);
        }
        return this;
    }

    protected MicroSite<DN, B> _site(File site) {
        this.site = new File(site.toURI());
        this.siteReader = this.site.exists() ? new Zip(this.site) : null;
        return this;
    }

    private void renderPage() {
        try {
            String content;
            String string = content = this.siteReader != null ? this.siteReader.read(this.pageName()) : null;
            if (content == null) {
                ((MicroSiteNotifier)this.notifier).renderPageNotFound();
                return;
            }
            ((MicroSiteNotifier)this.notifier).renderPage(content);
        }
        catch (NoSuchFileException content) {
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String pageName() {
        return this.page == 0 ? "index.html" : this.page + ".html";
    }

    private int normalize(String page) {
        try {
            return Integer.parseInt(page == null || page.equals("index.html") ? "0" : page.replace(".html", ""));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

