/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractActionToggle;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.alexandria.ui.displays.events.actionable.ToggleListener;
import io.intino.alexandria.ui.displays.notifiers.ActionToggleNotifier;

public class ActionToggle<DN extends ActionToggleNotifier, B extends Box>
extends AbstractActionToggle<DN, B> {
    private ToggleEvent.State state;
    private ToggleListener toggleListener;

    public ActionToggle(B box) {
        super(box);
    }

    public ActionToggle<DN, B> onToggle(ToggleListener listener) {
        this.toggleListener = listener;
        return this;
    }

    public ToggleEvent.State state() {
        return this.state;
    }

    public ActionToggle<DN, B> state(ToggleEvent.State state) {
        this._state(state);
        ((ActionToggleNotifier)this.notifier).refreshState(state.name());
        return this;
    }

    public ActionToggle<DN, B> toggle(ToggleEvent.State state) {
        this.state(state);
        this.notifyToggle();
        return this;
    }

    public void toggle() {
        this.state = this.state == ToggleEvent.State.On ? ToggleEvent.State.Off : ToggleEvent.State.On;
        this.notifyToggle();
    }

    protected ActionToggle<DN, B> _state(ToggleEvent.State state) {
        this.state = state;
        return this;
    }

    private void notifyToggle() {
        ((ActionToggleNotifier)this.notifier).refreshState(this.state.name());
        if (this.toggleListener == null) {
            return;
        }
        this.toggleListener.accept(new ToggleEvent((Display)this, this.state));
    }
}

