package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.PageCollection;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class PageCollectionRequester extends CollectionRequester {

	public PageCollectionRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		PageCollection display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("changePage")) {
			display.changePage(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("changePageSize")) {
			display.changePageSize(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("notifyItemsRendered")) {
			display.notifyItemsRendered(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.CollectionItemsRenderedInfo.class));
			return;
		}
		else if (operation.equals("loadMoreItems")) {
			display.loadMoreItems(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.CollectionMoreItems.class));
			return;
		}

		super.execute();
	}
}