package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.PageCollection;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class PageCollectionPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		PageCollection display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("changePage")) {
			display.changePage(Integer.parseInt(data));
			return;
		}
		else if (operation.equals("changePageSize")) {
			display.changePageSize(Integer.parseInt(data));
			return;
		}
		else if (operation.equals("notifyItemsRendered")) {
			display.notifyItemsRendered(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.CollectionItemsRenderedInfo.class));
			return;
		}
		else if (operation.equals("loadMoreItems")) {
			display.loadMoreItems(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.CollectionMoreItems.class));
			return;
		}

		super.execute(client, message);
	}

}