package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.ImageEditable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class ImageEditableRequester extends BaseImageRequester {

	public ImageEditableRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		ImageEditable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyChange")) {
			display.notifyChange(manager.fromForm("v"));
			return;
		}

		super.execute();
	}
}