/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.dynamictable;

import io.intino.alexandria.ui.model.dynamictable.Column;
import io.intino.alexandria.ui.model.dynamictable.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Section {
    private String label;
    private String color;
    private String backgroundColor;
    private int fontSize;
    private List<Row> rowList = new ArrayList<Row>();
    private List<Section> sectionList = new ArrayList<Section>();
    private List<String> columnNames = new ArrayList<String>();

    public Section(String label) {
        this(label, "black", "#efefef", 12);
    }

    public Section(String label, String color, String backgroundColor, int fontSizeInPt) {
        this.label = label;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSizeInPt;
    }

    public String label() {
        return this.label;
    }

    public Section label(String label) {
        this.label = label;
        return this;
    }

    public String color() {
        return this.color;
    }

    public Section color(String color) {
        this.color = color;
        return this;
    }

    public String backgroundColor() {
        return this.backgroundColor;
    }

    public Section backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public int fontSize() {
        return this.fontSize;
    }

    public Section fontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public List<Row> rows() {
        return this.rowList;
    }

    public List<String> columns() {
        return this.columnNames;
    }

    public Section columns(String ... columnNames) {
        this.columns(Arrays.asList(columnNames));
        return this;
    }

    public Section columns(List<String> columnNameList) {
        this.columnNames = columnNameList;
        return this;
    }

    public Section add(String rowLabel, List<Double> values) {
        return this.add(rowLabel, values.stream().mapToDouble(v -> v).toArray());
    }

    public Section add(String rowLabel, double ... values) {
        Row row = new Row(rowLabel);
        if (this.columnNames.size() != values.length) {
            throw new NumberFormatException("Columns and value size must be equal");
        }
        for (int i = 0; i < values.length; ++i) {
            row.add(new Column(this.columnNames.get(i), values[i]));
        }
        this.rowList.add(row);
        return this;
    }

    public Section add(Row row) {
        this.rowList.add(row);
        return this;
    }

    public List<Section> sections() {
        return this.sectionList;
    }

    public Section add(String label) {
        return this.add(new Section(label));
    }

    public Section add(String label, String color, String backgroundColor, int fontSize) {
        return this.add(new Section(label, color, backgroundColor, fontSize));
    }

    public Section add(Section section) {
        this.sectionList.add(section);
        return section;
    }
}

