/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.loaders;

import io.intino.alexandria.ui.displays.components.collection.loaders.ItemLoader;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalPageDatasource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageItemLoader<DS extends Datasource<Item>, Item>
extends ItemLoader<DS, Item> {
    private int pageSize;

    public PageItemLoader(DS source, int pageSize) {
        super(source);
        this.pageSize = pageSize;
    }

    public PageItemLoader pageSize(int size) {
        this.pageSize = size;
        return this;
    }

    public synchronized List<Item> page(int page) {
        page = this.checkPageRange(page);
        return this.items(this.start(page), this.pageSize);
    }

    public int pageCount() {
        if (this.pageSize <= 0) {
            return 0;
        }
        return this.pageOf(this.itemCount());
    }

    public int start(int page) {
        return page * this.pageSize;
    }

    public int pageOf(long index) {
        return (int)(Math.floor(index / (long)this.pageSize) + (double)(index % (long)this.pageSize > 0L ? 1 : 0));
    }

    public List<Item> moreItems(int start, int stop) {
        return this.items(start, stop - start + 1);
    }

    private int checkPageRange(int page) {
        int countPages;
        if (page <= 0) {
            page = 0;
        }
        if (page >= (countPages = this.pageCount()) && countPages > 0) {
            page = countPages - 1;
        }
        return page;
    }

    private List<Item> items(int start, int pageSize) {
        ArrayList<String> sortings = new ArrayList<String>(this.sortings);
        if (this.source instanceof TemporalPageDatasource) {
            return this.timetag != null ? ((TemporalPageDatasource)this.source).items(this.timetag, start, pageSize, this.condition, this.filters, sortings) : Collections.emptyList();
        }
        return ((PageDatasource)this.source).items(start, pageSize, this.condition, this.filters, sortings);
    }
}

