/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.loaders;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.MapDatasource;
import io.intino.alexandria.ui.model.datasource.MemoryDatasource;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.datasource.filters.RangeFilter;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalDatasource;
import io.intino.alexandria.ui.model.datasource.temporal.TemporalPageDatasource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ItemLoader<DS extends Datasource<Item>, Item> {
    private long itemCount;
    final DS source;
    String condition;
    List<Filter> filters = new ArrayList<Filter>();
    HashSet<String> sortings = new HashSet();
    Timetag timetag = null;

    public ItemLoader(DS source) {
        this.source = source;
        this.itemCount = this.calculateItemCount(null);
    }

    public ItemLoader reload() {
        this.itemCount = this.calculateItemCount(this.condition);
        return this;
    }

    public ItemLoader clearFilters() {
        this.condition = null;
        this.filters.clear();
        this.itemCount = this.calculateItemCount(this.condition);
        return this;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public ItemLoader filter(String grouping, List<String> groups) {
        if (groups.size() <= 0) {
            this.remove(grouping);
        } else {
            Filter filter = this.filter(grouping);
            if (filter == null) {
                this.filters.add(new GroupFilter(grouping, groups));
            } else {
                ((GroupFilter)filter).groups(groups);
            }
        }
        this.itemCount = this.calculateItemCount(this.condition);
        return this;
    }

    public ItemLoader filter(String grouping, Instant from, Instant to) {
        Filter filter = this.filter(grouping);
        if (filter == null) {
            this.filters.add(new RangeFilter(grouping, from, to));
        } else {
            ((RangeFilter)filter).from(from).to(to);
        }
        this.itemCount = this.calculateItemCount(this.condition);
        return this;
    }

    public void removeFilter(String grouping) {
        this.remove(grouping);
        this.itemCount = this.calculateItemCount(this.condition);
    }

    public String condition() {
        return this.condition;
    }

    public ItemLoader condition(String condition) {
        this.condition = condition;
        this.itemCount = this.calculateItemCount(condition);
        return this;
    }

    public ItemLoader timetag(Timetag timetag) {
        this.timetag = timetag;
        this.itemCount = this.calculateItemCount(this.condition);
        return this;
    }

    public void sortings(List<String> sortings) {
        this.sortings.clear();
        this.sortings.addAll(sortings);
    }

    public void addSorting(String sorting) {
        this.sortings.add(sorting);
    }

    public void removeSorting(String sorting) {
        this.sortings.remove(sorting);
    }

    public List<Item> items(String ... sortings) {
        int itemCount = Long.valueOf(this.itemCount()).intValue();
        List<String> sortingList = Arrays.asList(sortings);
        if (this.source instanceof TemporalDatasource) {
            return this.timetag != null ? ((TemporalDatasource)this.source).items(this.timetag, 0, itemCount, this.condition, this.filters, sortingList) : Collections.emptyList();
        }
        if (this.source instanceof TemporalPageDatasource) {
            return this.timetag != null ? ((TemporalPageDatasource)this.source).items(this.timetag, 0, itemCount, this.condition, this.filters, sortingList) : Collections.emptyList();
        }
        if (this.source instanceof MemoryDatasource) {
            return ((MemoryDatasource)this.source).items(0, itemCount, this.condition, this.filters, sortingList);
        }
        if (this.source instanceof PageDatasource) {
            return ((PageDatasource)this.source).items(0, itemCount, this.condition, this.filters, sortingList);
        }
        return Collections.emptyList();
    }

    public long itemCount() {
        return this.itemCount;
    }

    private Filter filter(String grouping) {
        return this.filters.stream().filter((? super T f) -> f.grouping().equalsIgnoreCase(grouping)).findFirst().orElse(null);
    }

    private void remove(String grouping) {
        Filter filter = this.filter(grouping);
        if (filter != null) {
            this.filters.remove(filter);
        }
    }

    private long calculateItemCount(String condition) {
        if (this.source instanceof TemporalDatasource) {
            return this.timetag != null ? ((TemporalDatasource)this.source).itemCount(this.timetag, condition, this.filters) : 0L;
        }
        if (this.source instanceof TemporalPageDatasource) {
            return this.timetag != null ? ((TemporalPageDatasource)this.source).itemCount(this.timetag, condition, this.filters) : 0L;
        }
        if (this.source instanceof MemoryDatasource) {
            return ((MemoryDatasource)this.source).itemCount(condition, this.filters);
        }
        if (this.source instanceof MapDatasource) {
            return ((MapDatasource)this.source).placeMarkCount(condition, this.filters);
        }
        if (this.source instanceof PageDatasource) {
            return ((PageDatasource)this.source).itemCount(condition, this.filters);
        }
        return 0L;
    }
}

