/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection.behaviors;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.loaders.ItemLoader;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.Filter;
import java.time.Instant;
import java.util.List;
import java.util.function.Consumer;

public abstract class CollectionBehavior<DS extends Datasource<Item>, Item, IL extends ItemLoader<DS, Item>> {
    private final Collection collection;
    IL itemLoader;

    public CollectionBehavior(Collection collection) {
        this.collection = collection;
    }

    public <C extends Collection> C collection() {
        return (C)this.collection;
    }

    public IL itemLoader() {
        return this.itemLoader;
    }

    public CollectionBehavior setup(DS source) {
        if (source == null) {
            return this;
        }
        this.itemLoader = new ItemLoader(source);
        return this;
    }

    public void reload() {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).reload());
    }

    public List<Filter> filters() {
        return ((ItemLoader)this.itemLoader).filters();
    }

    public void clearFilters() {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).clearFilters());
    }

    public void filter(String grouping, List<String> groups) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).filter(grouping, groups));
    }

    public void filter(String grouping, Instant from, Instant to) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).filter(grouping, from, to));
    }

    public void removeFilter(String grouping) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).removeFilter(grouping));
    }

    public String condition() {
        return ((ItemLoader)this.itemLoader).condition();
    }

    public void condition(String condition) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).condition(condition));
    }

    public void timetag(Timetag timetag) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).timetag(timetag));
    }

    public void sortings(List<String> sortings) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).sortings(sortings));
    }

    public void addSorting(String sorting) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).addSorting(sorting));
    }

    public void removeSorting(String sorting) {
        this.computeUpdate(e -> ((ItemLoader)this.itemLoader).removeSorting(sorting));
    }

    public List<Item> items(String ... sortings) {
        return ((ItemLoader)this.itemLoader).items(sortings);
    }

    public long itemCount() {
        return ((ItemLoader)this.itemLoader).itemCount();
    }

    void computeUpdate(Consumer<Void> consumer) {
        this.computeUpdate(consumer, true);
    }

    void computeUpdate(Consumer<Void> consumer, boolean reset) {
        this.collection.loading(true);
        consumer.accept(null);
        if (reset) {
            this.reset();
        }
        this.collection.loading(false);
    }

    void reset() {
        this.collection.clear();
        this.update();
    }

    abstract void update();
}

