/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.SelectorMenuSelection;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractSelectorMenu;
import io.intino.alexandria.ui.displays.notifiers.SelectorMenuNotifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SelectorMenu<DN extends SelectorMenuNotifier, B extends Box>
extends AbstractSelectorMenu<DN, B> {
    private int selected;

    public SelectorMenu(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.select(this.selected);
    }

    public List<String> selection() {
        return Collections.singletonList(this.nameOf(this.selected));
    }

    @Override
    public void reset() {
        this.selected = -1;
        ((SelectorMenuNotifier)this.notifier).refreshSelected(new SelectorMenuSelection().option(-1));
    }

    public void selection(String option) {
        int position = this.position(option);
        if (position == -1) {
            return;
        }
        this.selection(position);
    }

    public void selection(int option) {
        ((SelectorMenuNotifier)this.notifier).refreshSelected(new SelectorMenuSelection().option(option).ancestors(this.ancestors(option)));
        if (this.selected == option) {
            return;
        }
        this.selected = option;
    }

    public void select(String option) {
        this.selection(option);
        this.notifySelection();
    }

    public void select(int option) {
        this.selection(option);
        this.notifySelection();
    }

    private List<String> ancestors(int option) {
        return this.findOption(option).ancestors().stream().map(Display::label).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

