/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractSelectorComboBox;
import io.intino.alexandria.ui.displays.components.selector.SelectorOption;
import io.intino.alexandria.ui.displays.notifiers.SelectorComboBoxNotifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SelectorComboBox<DN extends SelectorComboBoxNotifier, B extends Box>
extends AbstractSelectorComboBox<DN, B> {
    private List<String> selection = new ArrayList<String>();

    public SelectorComboBox(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.updateSelection(this.selection);
    }

    public List<String> selection() {
        return this.selection;
    }

    public SelectorComboBox<DN, B> multipleSelection(boolean multipleSelection) {
        this._multipleSelection(multipleSelection);
        ((SelectorComboBoxNotifier)this.notifier).refreshMultipleSelection(multipleSelection);
        return this;
    }

    @Override
    public void reset() {
        this.select(new String[0]);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.children().stream().filter(c -> c instanceof SelectorOption).forEach(Display::refresh);
    }

    public void selection(String ... selection) {
        this.selection(Arrays.asList(selection));
    }

    public void selection(List<String> selection) {
        this.selection = selection;
        ((SelectorComboBoxNotifier)this.notifier).refreshSelection(this.selection);
    }

    public void select(String ... options) {
        this.updateSelection(Arrays.asList(options));
    }

    public void updateSelection(List<String> options) {
        this.selection(options);
        this.notifySelection();
    }
}

