/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractCollectionDialog;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.SearchBox;
import io.intino.alexandria.ui.displays.components.collection.Selectable;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.notifiers.CollectionDialogNotifier;
import java.util.List;
import java.util.Optional;

public class CollectionDialog<DN extends CollectionDialogNotifier, B extends Box>
extends AbstractCollectionDialog<DN, B> {
    private boolean allowSearch = true;
    private SelectionListener selectionListener = null;
    private SearchBox searchBox;
    private Collection collection;

    public CollectionDialog(B box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.createSearchBox();
    }

    @Override
    public void open() {
        super.open();
        this.searchBox().ifPresent(sb -> sb.search(""));
        if (this.collection != null) {
            this.collection.init();
        }
    }

    public CollectionDialog onSelect(SelectionListener listener) {
        this.selectionListener = listener;
        return this;
    }

    public void bindTo(Selectable collection) {
        this.collection = (Collection)((Object)collection);
        this.searchBox().ifPresent(searchBox -> searchBox.bindTo((Collection)((Object)collection)));
        collection.onSelect(event -> this.updateSelection(event.selection()));
    }

    protected CollectionDialog _allowSearch(boolean value) {
        this.allowSearch = value;
        return this;
    }

    private <T> void updateSelection(List<T> selection) {
        this.close();
        this.notifySelection(selection);
    }

    private <T> void notifySelection(List<T> selection) {
        if (this.selectionListener == null) {
            return;
        }
        this.selectionListener.accept(new SelectionEvent(this, selection));
    }

    private void createSearchBox() {
        if (!this.allowSearch) {
            return;
        }
        this.searchBox = new SearchBox(this.box());
        this.add(this.searchBox);
    }

    private Optional<SearchBox> searchBox() {
        return Optional.ofNullable(this.searchBox);
    }
}

