/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.LocationCenter;
import io.intino.alexandria.schemas.LocationSetup;
import io.intino.alexandria.schemas.LocationZoomRange;
import io.intino.alexandria.ui.Asset;
import io.intino.alexandria.ui.displays.components.AbstractBaseLocation;
import io.intino.alexandria.ui.displays.components.geo.PlaceMarkBuilder;
import io.intino.alexandria.ui.displays.notifiers.BaseLocationNotifier;
import io.intino.alexandria.ui.model.Geometry;
import java.net.URL;

public class BaseLocation<DN extends BaseLocationNotifier, B extends Box>
extends AbstractBaseLocation<DN, B> {
    private URL icon = null;
    private Geometry value = null;

    public BaseLocation(B box) {
        super(box);
    }

    public Geometry value() {
        return this.value;
    }

    public BaseLocation<DN, B> value(String value) {
        return this.value(value != null ? Geometry.fromWkt(value) : null);
    }

    public BaseLocation<DN, B> value(Geometry location) {
        this._value(location);
        this.refresh();
        return this;
    }

    public BaseLocation<DN, B> zoom(int zoom) {
        ((BaseLocationNotifier)this.notifier).refreshZoom(zoom);
        return this;
    }

    public BaseLocation<DN, B> zoomRange(int min, int max) {
        ((BaseLocationNotifier)this.notifier).refreshZoomRange(new LocationZoomRange().min(min).max(max));
        return this;
    }

    public BaseLocation<DN, B> center(double latitude, double longitude) {
        ((BaseLocationNotifier)this.notifier).refreshCenter(new LocationCenter().lat(latitude).lng(longitude));
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.setup();
        this.refresh();
    }

    @Override
    public void refresh() {
        ((BaseLocationNotifier)this.notifier).refresh(this.value != null ? PlaceMarkBuilder.buildGeometry(this.value) : null);
    }

    protected <D extends BaseLocation> D _icon(URL icon) {
        this.icon = icon;
        return (D)this;
    }

    protected <D extends BaseLocation> D _value(Geometry value) {
        this.value = value;
        return (D)this;
    }

    protected <D extends BaseLocation> D _value(String value) {
        return this._value(Geometry.fromWkt(value));
    }

    private void setup() {
        if (this.icon == null) {
            return;
        }
        LocationSetup setup = new LocationSetup();
        setup.icon(Asset.toResource(this.baseAssetUrl(), this.icon).toUrl().toString());
        ((BaseLocationNotifier)this.notifier).setup(setup);
    }
}

