/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Group;
import io.intino.alexandria.ui.displays.components.AbstractBaseGrouping;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.notifiers.BaseGroupingNotifier;
import io.intino.alexandria.ui.model.Datasource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BaseGrouping<DN extends BaseGroupingNotifier, B extends Box>
extends AbstractBaseGrouping<DN, B> {
    private List<Collection> collections = new ArrayList<Collection>();
    private List<String> selection;
    private SelectionListener selectionListener;
    private List<io.intino.alexandria.ui.model.datasource.Group> groups = new ArrayList<io.intino.alexandria.ui.model.datasource.Group>();

    public BaseGrouping(B box) {
        super(box);
    }

    public BaseGrouping onSelect(SelectionListener listener) {
        this.selectionListener = listener;
        return this;
    }

    public BaseGrouping groups(List<io.intino.alexandria.ui.model.datasource.Group> groups) {
        this._groups(groups);
        this.refresh();
        return this;
    }

    public void select(List<String> groups) {
        this.selection = new ArrayList<String>(groups);
        this.notifySelection();
        this.collections.forEach(c -> c.filter(this.key(), this.selection));
    }

    public BaseGrouping<DN, B> bindTo(Collection ... collections) {
        this.collections = Arrays.stream(collections).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.collections.size() > 0) {
            Collection collection = this.collections.get(0);
            if (collection.ready()) {
                this.loadGroups();
            } else {
                collection.onReady(event -> this.loadGroups());
            }
        }
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.groups.size() > 0) {
            this.refreshGroups();
        }
    }

    protected BaseGrouping _groups(List<io.intino.alexandria.ui.model.datasource.Group> groups) {
        this.groups = groups;
        return this;
    }

    private String key() {
        return this.label() != null && !this.label().isEmpty() ? this.label() : this.name();
    }

    private void loadGroups() {
        if (this.collections.size() <= 0) {
            return;
        }
        this._groups(((Datasource)this.collections.get(0).source()).groups(this.key()));
        this.refreshGroups();
    }

    private void refreshGroups() {
        ((BaseGroupingNotifier)this.notifier).refreshGroups(this.groups.stream().map(this::groupOf).collect(Collectors.toList()));
    }

    private Group groupOf(io.intino.alexandria.ui.model.datasource.Group group) {
        return new Group().label(group.label()).count(group.count()).color(group.color());
    }

    private void notifySelection() {
        ((BaseGroupingNotifier)this.notifier).refreshSelection(this.selection);
        if (this.selectionListener == null) {
            return;
        }
        this.selectionListener.accept(new SelectionEvent(this, this.selection));
    }
}

