package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.notifiers.SelectorRadioBoxNotifier;

import java.util.List;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

public class SelectorRadioBox<DN extends SelectorRadioBoxNotifier, B extends Box> extends AbstractSelectorRadioBox<DN, B> {
	private String selected;

    public SelectorRadioBox(B box) {
        super(box);
    }

	@Override
	public void didMount() {
		super.didMount();
		selection(selected);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> selection() {
		return selected != null ? singletonList(selected) : emptyList();
	}

	public void selection(String value) {
		notifier.refreshSelected(nameOf(value));
		if (selected != null && selected.equals(value)) return;
		selected = value;
	}

	public void select(String value) {
    	selection(value);
		notifySelection();
	}

	@Override
	public void reset() {
		selected = null;
		notifier.refreshSelected(null);
	}
}