/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.timeline;

import io.intino.alexandria.Scale;
import io.intino.alexandria.ui.model.timeline.MagnitudeDefinition;
import java.time.Instant;
import java.util.List;
import java.util.Map;

public interface TimelineDatasource {
    public String name();

    public List<MagnitudeDefinition> magnitudes();

    public Magnitude magnitude(MagnitudeDefinition var1);

    public List<Scale> scales();

    public Instant from(Scale var1);

    public Instant previous(Instant var1, Scale var2);

    public Instant next(Instant var1, Scale var2);

    public Instant to(Scale var1);

    default public MagnitudeDefinition magnitudeDefinition(String name) {
        return this.magnitudes().stream().filter(d -> d.name().equals(name)).findFirst().orElse(null);
    }

    default public Magnitude magnitude(String magnitudeName) {
        MagnitudeDefinition magnitude = this.magnitudeDefinition(magnitudeName);
        return magnitude != null ? this.magnitude(magnitude) : null;
    }

    public static interface Serie {
        public String name();

        public Map<Instant, Double> values();
    }

    public static interface Summary {
        public double average();

        public Instant averageDate();

        public double max();

        public Instant maxDate();

        public double min();

        public Instant minDate();
    }

    public static interface Magnitude {
        public MagnitudeDefinition definition();

        public Status status();

        public double value();

        public Double min();

        public Double max();

        public Double percentage();

        public Summary summary(Instant var1, Scale var2);

        public Serie serie(Scale var1, Instant var2);

        public Serie serie(Scale var1, Instant var2, Instant var3);

        public String customHtmlView(Scale var1);

        public static enum Status {
            Normal,
            Warning,
            Error;

        }
    }
}

