/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.reel;

import io.intino.alexandria.Scale;
import io.intino.alexandria.ui.model.reel.SignalDefinition;
import java.time.Instant;
import java.util.List;

public interface ReelDatasource {
    public String name();

    public List<SignalDefinition> signals();

    public Signal signal(SignalDefinition var1);

    public List<Scale> scales();

    public Instant from(Scale var1);

    public Instant to(Scale var1);

    public Instant previous(Instant var1, Scale var2);

    public Instant next(Instant var1, Scale var2);

    default public SignalDefinition signalDefinition(String name) {
        return this.signals().stream().filter(d -> d.name().equals(name)).findFirst().orElse(null);
    }

    default public Signal signal(String signalName) {
        SignalDefinition signal = this.signalDefinition(signalName);
        return signal != null ? this.signal(signal) : null;
    }

    public static interface Signal {
        public SignalDefinition definition();

        public String reel(Scale var1, Instant var2, Instant var3);
    }
}

