/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.ReelFetch;
import io.intino.alexandria.schemas.ReelSignalSorting;
import io.intino.alexandria.ui.displays.components.Reel;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.ComponentRequester;
import io.intino.alexandria.ui.spark.UISparkManager;
import java.util.List;

public class ReelRequester
extends ComponentRequester {
    public ReelRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        Reel display = (Reel)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("fetch")) {
            display.fetch((ReelFetch)Json.fromString((String)this.manager.fromQuery("v"), ReelFetch.class));
            return;
        }
        if (operation.equals("signalsSorting")) {
            display.signalsSorting(List.of((ReelSignalSorting[])Json.fromString((String)this.manager.fromQuery("v"), ReelSignalSorting[].class)));
            return;
        }
        if (operation.equals("first")) {
            display.first();
            return;
        }
        if (operation.equals("previous")) {
            display.previous();
            return;
        }
        if (operation.equals("next")) {
            display.next();
            return;
        }
        if (operation.equals("last")) {
            display.last();
            return;
        }
        if (operation.equals("changeScale")) {
            display.changeScale(this.manager.fromQuery("v"));
            return;
        }
        super.execute();
    }
}

