/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.TimelineHistory;
import io.intino.alexandria.schemas.TimelineHistoryEntry;
import io.intino.alexandria.schemas.TimelineHistoryFetch;
import io.intino.alexandria.schemas.TimelineMagnitude;
import io.intino.alexandria.schemas.TimelineMagnitudeSorting;
import io.intino.alexandria.schemas.TimelineMagnitudeVisibility;
import io.intino.alexandria.schemas.TimelineSerie;
import io.intino.alexandria.schemas.TimelineSetup;
import io.intino.alexandria.schemas.TimelineSummary;
import io.intino.alexandria.schemas.TimelineSummaryValue;
import io.intino.alexandria.schemas.TimelineToolbarInfo;
import io.intino.alexandria.ui.displays.components.AbstractTimeline;
import io.intino.alexandria.ui.displays.notifiers.TimelineNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.timeline.Formatter;
import io.intino.alexandria.ui.model.timeline.MagnitudeDefinition;
import io.intino.alexandria.ui.model.timeline.TimelineDatasource;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Timeline<DN extends TimelineNotifier, B extends Box>
extends AbstractTimeline<B> {
    private TimelineDatasource source;
    private Mode mode;
    private String stateLabel;
    private String historyLabel;
    private List<TimelineMagnitudeVisibility> magnitudesVisibility;
    private List<TimelineMagnitudeSorting> magnitudesSorting;
    private int summaryPointsCount = 24;
    private final Map<Scale, Instant> selectedInstants = new HashMap<Scale, Instant>();
    private Scale selectedScale = null;
    private static final int DefaultSummaryPointsCount = 24;
    private static final Set<String> EnglishNotationLanguages = Set.of("mx", "en");

    public Timeline(B box) {
        super(box);
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> stateLabel(String label) {
        this.stateLabel = label;
        return this;
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> historyLabel(String label) {
        this.historyLabel = label;
        return this;
    }

    public <DS extends TimelineDatasource> Timeline<DN, B> source(DS source) {
        this.source = source;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    protected Timeline<DN, B> _mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public List<TimelineMagnitudeVisibility> magnitudesVisibility() {
        return this.magnitudesVisibility;
    }

    public Timeline<DN, B> magnitudesVisibility(List<TimelineMagnitudeVisibility> magnitudesVisibility) {
        this.magnitudesVisibility = magnitudesVisibility;
        ((TimelineNotifier)this.notifier).refreshMagnitudesVisibility(magnitudesVisibility);
        return this;
    }

    public List<TimelineMagnitudeSorting> magnitudesSorting() {
        return this.magnitudesSorting;
    }

    public Timeline<DN, B> magnitudesSorting(List<TimelineMagnitudeSorting> magnitudesSorting) {
        this.magnitudesSorting = magnitudesSorting;
        ((TimelineNotifier)this.notifier).refreshMagnitudesSorting(magnitudesSorting);
        return this;
    }

    public Timeline<DN, B> summaryPointsCount(int count) {
        this.summaryPointsCount = count;
        return this;
    }

    public void first() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.from(scale));
    }

    public void previous() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant from = this.source.from(scale);
        if ((current = this.source.previous(current, this.selectedScale())).isBefore(from)) {
            current = from;
        }
        this.selectInstant(scale, current);
    }

    public void next() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant to = this.source.to(scale);
        if ((current = this.source.next(current, this.selectedScale())).isAfter(to)) {
            current = to;
        }
        this.selectInstant(scale, current);
    }

    public void last() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.to(scale));
    }

    public void changeScale(String scale) {
        this.selectedScale = Scale.valueOf((String)scale);
        this.refreshToolbar();
        this.refreshMagnitudes();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Timeline source not defined");
        }
        ((TimelineNotifier)this.notifier).setup(new TimelineSetup().mode(this.mode.name()).name(this.source.name()).stateLabel(this.stateLabel).historyLabel(this.historyLabel).scales(this.source.scales().stream().map(Enum::name).collect(Collectors.toList())).toolbar(this.toolbar()).magnitudes(this.source.magnitudes().stream().map(this::schemaOf).collect(Collectors.toList())));
    }

    private TimelineToolbarInfo toolbar() {
        Scale scale = this.selectedScale();
        Instant date = this.selectedInstant(scale);
        TimelineToolbarInfo result = new TimelineToolbarInfo();
        result.label(ScaleFormatter.label(date, scale, this.language()));
        result.scale(this.selectedScale().name());
        result.canPrevious(!ScaleFormatter.label(date, scale, this.language()).equals(ScaleFormatter.label(this.source.from(scale), scale, this.language())));
        result.canNext(!ScaleFormatter.label(date, scale, this.language()).equals(ScaleFormatter.label(this.source.to(scale), scale, this.language())));
        return result;
    }

    public void openHistory(String magnitudeName) {
        Scale scale = this.selectedScale;
        ((TimelineNotifier)this.notifier).showHistoryDialog(new TimelineHistory().from(this.source.from(scale)).to(this.source.to(scale)));
    }

    public void fetch(TimelineHistoryFetch fetch) {
        TimelineDatasource.Magnitude magnitude = this.source.magnitude(fetch.magnitude());
        Scale scale = this.selectedScale();
        Map<Instant, Double> values = magnitude.serie(scale, fetch.start(), fetch.end()).values();
        Formatter formatter = magnitude.definition().formatter();
        ((TimelineNotifier)this.notifier).refreshHistory(this.fillWithZeros(values, fetch.end(), scale).entrySet().stream().map(e -> this.historyEntryOf((Map.Entry<Instant, Double>)e, formatter)).collect(Collectors.toList()));
    }

    private TimelineHistoryEntry historyEntryOf(Map.Entry<Instant, Double> entry, Formatter formatter) {
        return new TimelineHistoryEntry().date(entry.getKey()).value(entry.getValue()).formattedValue(formatter.format(entry.getValue()));
    }

    private TimelineSummary summaryOf(TimelineDatasource.Magnitude magnitude) {
        Scale scale = this.selectedScale();
        Formatter formatter = magnitude.definition().formatter();
        Instant date = this.selectedInstant(scale);
        TimelineDatasource.Summary summary = magnitude.summary(date, scale);
        return new TimelineSummary().average(this.summaryValueOf(summary.average(), date, formatter)).max(this.summaryValueOf(summary.max(), summary.maxDate(), formatter)).min(this.summaryValueOf(summary.min(), summary.minDate(), formatter));
    }

    private TimelineSummaryValue summaryValueOf(double value, Instant date, Formatter formatter) {
        return new TimelineSummaryValue().value(this.adapt(formatter.format(value))).date(date);
    }

    private TimelineSerie serieOf(TimelineDatasource.Magnitude magnitude) {
        TimelineSerie result = new TimelineSerie();
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        TimelineDatasource.Serie serie = magnitude.serie(scale, current);
        List<Double> values = this.loadValues(serie);
        Formatter formatter = magnitude.definition().formatter();
        result.name(serie.name());
        result.categories(this.categoriesOf(serie, current, scale));
        result.values(values);
        result.formattedValues(values.stream().map(formatter::format).collect(Collectors.toList()));
        return result;
    }

    private List<String> categoriesOf(TimelineDatasource.Serie serie, Instant to, Scale scale) {
        return this.loadCategories(serie, to, scale).stream().map(d -> this.date((Instant)d, scale)).collect(Collectors.toList());
    }

    private List<Instant> loadCategories(TimelineDatasource.Serie serie, Instant to, Scale scale) {
        ArrayList<Instant> result = new ArrayList<Instant>(serie.values().keySet());
        return this.reverse(this.fill(this.reverse(result).subList(0, Math.min(result.size(), this.summaryPointsCount)), to, scale));
    }

    private List<Double> loadValues(TimelineDatasource.Serie serie) {
        ArrayList<Double> values = new ArrayList<Double>(serie.values().values());
        return this.reverse(this.fillWithZeros(this.reverse(values).subList(0, Math.min(values.size(), this.summaryPointsCount))));
    }

    private TimelineDatasource.Magnitude magnitude(MagnitudeDefinition definition) {
        return this.source.magnitude(definition);
    }

    private List<Instant> fill(List<Instant> result, Instant to, Scale scale) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        LocalDateTime mockDate = LocalDateTime.ofInstant(result.isEmpty() ? to : result.get(result.size() - 1), ZoneOffset.UTC);
        while (result.size() < this.summaryPointsCount) {
            mockDate = mockDate.minus(1L, this.chronoUnitOf(scale));
            result.add(mockDate.toInstant(ZoneOffset.UTC));
        }
        return result;
    }

    private TemporalUnit chronoUnitOf(Scale scale) {
        if (scale == Scale.Hour) {
            return ChronoUnit.HOURS;
        }
        if (scale == Scale.Minute) {
            return ChronoUnit.MINUTES;
        }
        if (scale == Scale.Day) {
            return ChronoUnit.DAYS;
        }
        if (scale == Scale.Week) {
            return ChronoUnit.WEEKS;
        }
        if (scale == Scale.Month) {
            return ChronoUnit.MONTHS;
        }
        return ChronoUnit.YEARS;
    }

    private Map<Instant, Double> fillWithZeros(Map<Instant, Double> result, Instant to, Scale scale) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        LocalDateTime mockDate = LocalDateTime.ofInstant(result.isEmpty() ? to : new ArrayList<Instant>(result.keySet()).get(0), ZoneOffset.UTC);
        while (result.size() < this.summaryPointsCount) {
            mockDate = mockDate.minus(1L, this.chronoUnitOf(scale));
            result.put(mockDate.toInstant(ZoneOffset.UTC), 0.0);
        }
        ArrayList<Instant> keys = new ArrayList<Instant>(result.keySet());
        keys.sort(Instant::compareTo);
        return keys.stream().collect(Collectors.toMap(k -> k, result::get, (k, v) -> k, LinkedHashMap::new));
    }

    private List<Double> fillWithZeros(List<Double> result) {
        if (result.size() >= this.summaryPointsCount) {
            return result;
        }
        while (result.size() < this.summaryPointsCount) {
            result.add(0.0);
        }
        return result;
    }

    private <T> List<T> reverse(List<T> result) {
        Collections.reverse(result);
        return result;
    }

    private String date(Instant date, Scale scale) {
        return ScaleFormatter.shortLabel(date, scale, this.language());
    }

    public String date(Instant date, String format, Function<String, String> translator) {
        if (date == null) {
            return null;
        }
        return Timeline.formatDate(translator.apply(format), date, Timeline.locale(this.language()));
    }

    private static String formatDate(String pattern, Instant instant, Locale locale) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        return format.format(Date.from(instant));
    }

    private static Locale locale(String language) {
        if (language.toLowerCase().contains("es")) {
            return new Locale("es", "ES");
        }
        if (language.toLowerCase().contains("pt")) {
            return new Locale("pt", "PT");
        }
        return new Locale("en", "EN");
    }

    private Instant selectedInstant(String scale) {
        return this.selectedInstant(Scale.valueOf((String)scale));
    }

    private Instant selectedInstant(Scale scale) {
        return this.selectedInstants.getOrDefault(scale, this.source.to(this.selectedScale()));
    }

    private Scale selectedScale() {
        return this.selectedScale != null ? this.selectedScale : this.source.scales().get(0);
    }

    private void selectInstant(Scale scale, Instant value) {
        this.selectedInstants.put(scale, value);
        this.refreshToolbar();
        this.refreshMagnitudes();
    }

    private void refreshToolbar() {
        ((TimelineNotifier)this.notifier).refreshHistoryToolbar(this.toolbar());
    }

    private void refreshMagnitudes() {
        ((TimelineNotifier)this.notifier).refreshMagnitudes(this.source.magnitudes().stream().map(this::schemaOf).collect(Collectors.toList()));
    }

    private TimelineMagnitude schemaOf(MagnitudeDefinition definition) {
        return this.schemaOf(this.magnitude(definition));
    }

    private TimelineMagnitude schemaOf(TimelineDatasource.Magnitude magnitude) {
        MagnitudeDefinition definition = magnitude.definition();
        Formatter formatter = definition.formatter();
        return new TimelineMagnitude().name(definition.name()).value(magnitude.value()).formattedValue(this.adapt(formatter.format(magnitude.value()))).status(magnitude.status().name()).min(magnitude.min() != null ? String.valueOf(magnitude.min()) : null).formattedMin(magnitude.min() != null ? this.adapt(formatter.format(magnitude.min())) : null).max(magnitude.max() != null ? String.valueOf(magnitude.max()) : null).formattedMax(magnitude.max() != null ? this.adapt(formatter.format(magnitude.max())) : null).percentage(magnitude.percentage() != null ? this.adapt(formatter.format(magnitude.percentage())) : null).label(definition.label(this.language())).unit(definition.unit()).summary(this.summaryOf(magnitude)).serie(this.serieOf(magnitude)).customView(magnitude.customHtmlView(this.selectedScale()));
    }

    private String adapt(String value) {
        if (!EnglishNotationLanguages.contains(this.language().toLowerCase())) {
            return value;
        }
        return value.replace(",", "COMMA").replace(".", ",").replace("COMMA", ".");
    }

    public static enum Mode {
        Summary,
        Catalog;

    }
}

