/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.SignActionSetup;
import io.intino.alexandria.schemas.SignActionSignatureFailure;
import io.intino.alexandria.schemas.SignActionSignatureSuccess;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.AbstractSignAction;
import io.intino.alexandria.ui.displays.components.sign.AutoFirmaServer;
import io.intino.alexandria.ui.displays.events.SignErrorEvent;
import io.intino.alexandria.ui.displays.events.SignErrorListener;
import io.intino.alexandria.ui.displays.events.SignEvent;
import io.intino.alexandria.ui.displays.events.SignListener;
import io.intino.alexandria.ui.displays.notifiers.SignActionNotifier;
import io.intino.icod.core.SignatureInfo;
import io.intino.icod.core.XadesSignatureHelper;

public abstract class SignAction<DN extends SignActionNotifier, B extends Box>
extends AbstractSignAction<DN, B> {
    public boolean readonly = false;
    protected AutoFirmaServer server;
    protected SignListener signListener;
    private SignErrorListener errorListener;
    private SignFormat format = SignFormat.XAdES;

    public SignAction(B box) {
        super(box);
    }

    public SignAction<DN, B> signFormat(SignFormat format) {
        this._signFormat(format);
        ((SignActionNotifier)this.notifier).format(format.name());
        return this;
    }

    @Override
    public void didMount() {
        super.didMount();
        ((SignActionNotifier)this.notifier).setup(this.setup());
        ((SignActionNotifier)this.notifier).refreshReadonly(this.readonly);
    }

    @Override
    public void init() {
        super.init();
        this.server = new AutoFirmaServer((AlexandriaUiBox)((Object)this.box()), this.session()).listen();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        ((SignActionNotifier)this.notifier).setup(this.setup());
    }

    @Override
    public SignAction<DN, B> readonly(boolean readonly) {
        this.readonly = readonly;
        ((SignActionNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    public void sign(String content) {
        if (content == null) {
            this.notifyUser(this.translate("No data to sign"), UserMessage.Type.Error);
            return;
        }
        ((SignActionNotifier)this.notifier).sign(content);
    }

    public void signing() {
        this.readonly(true);
        this.notifyUser(this.translate("Select certificate when requested by @firma application..."), UserMessage.Type.Loading);
    }

    public void success(SignActionSignatureSuccess success) {
        this.notifyUser(this.translate("Sign process finished"), UserMessage.Type.Success);
        this.signListener.accept(new SignEvent(this, success.signature(), success.certificate(), this.info(success.signature())));
    }

    public void failure(SignActionSignatureFailure failure) {
        this.notifyUser(this.translate("An error ocurred when signing"), UserMessage.Type.Error);
        this.errorListener.accept(new SignErrorEvent(this, failure != null ? failure.code() : "-", failure != null ? failure.message() : "-"));
    }

    public SignAction<DN, B> onSign(SignListener listener) {
        this.signListener = listener;
        return this;
    }

    public SignAction<DN, B> onError(SignErrorListener listener) {
        this.errorListener = listener;
        return this;
    }

    protected SignAction<DN, B> _signFormat(SignFormat format) {
        this.format = format;
        return this;
    }

    protected SignatureInfo info(String signature) {
        if (this.format != SignFormat.XAdES) {
            return new SignatureInfo(null, null, null);
        }
        return new XadesSignatureHelper().getInfo(signature);
    }

    private SignActionSetup setup() {
        SignActionSetup result = new SignActionSetup();
        result.downloadUrl(this.server.downloadUrl());
        result.storageUrl(this.server.storageUrl());
        result.retrieveUrl(this.server.retrieveUrl());
        result.batchPreSignerUrl(this.server.batchPreSignerUrl());
        result.batchPostSignerUrl(this.server.batchPostSignerUrl());
        return result;
    }

    public static enum SignFormat {
        PAdES,
        XAdES,
        CAdES;

    }
}

