/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.ReelFetch;
import io.intino.alexandria.schemas.ReelNavigationInfo;
import io.intino.alexandria.schemas.ReelSetup;
import io.intino.alexandria.schemas.ReelSignal;
import io.intino.alexandria.schemas.ReelSignalSorting;
import io.intino.alexandria.schemas.ReelSignalStep;
import io.intino.alexandria.schemas.ReelToolbarInfo;
import io.intino.alexandria.ui.displays.components.AbstractReel;
import io.intino.alexandria.ui.displays.notifiers.ReelNotifier;
import io.intino.alexandria.ui.model.ScaleFormatter;
import io.intino.alexandria.ui.model.reel.ReelDatasource;
import io.intino.alexandria.ui.model.reel.SignalDefinition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Reel<DN extends ReelNotifier, B extends Box>
extends AbstractReel<B> {
    private ReelDatasource source;
    private List<ReelSignalSorting> signalsSorting;
    private final Map<Scale, Instant> selectedInstants = new HashMap<Scale, Instant>();
    private Scale selectedScale = null;
    private int stepsCount = 24;
    private static final int DefaultStepsCount = 24;

    public Reel(B box) {
        super(box);
    }

    public <DS extends ReelDatasource> Reel<DN, B> source(DS source) {
        this.source = source;
        return this;
    }

    public List<ReelSignalSorting> signalsSorting() {
        return this.signalsSorting;
    }

    public Reel<DN, B> signalsSorting(List<ReelSignalSorting> signalsSorting) {
        this.signalsSorting = signalsSorting;
        ((ReelNotifier)this.notifier).refreshSignalsSorting(signalsSorting);
        return this;
    }

    public Reel<DN, B> stepsCount(int count) {
        this.stepsCount = count;
        return this;
    }

    public void first() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.from(scale));
    }

    public void previous() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant from = this.source.from(scale);
        if ((current = this.source.previous(current, this.selectedScale())).isBefore(from)) {
            current = from;
        }
        this.selectInstant(scale, current);
    }

    public void next() {
        Scale scale = this.selectedScale();
        Instant current = this.selectedInstant(scale);
        Instant to = this.source.to(scale);
        if ((current = this.source.next(current, this.selectedScale())).isAfter(to)) {
            current = to;
        }
        this.selectInstant(scale, current);
    }

    public void last() {
        Scale scale = this.selectedScale();
        this.selectInstant(scale, this.source.to(scale));
    }

    public void changeScale(String scale) {
        this.selectedScale = Scale.valueOf((String)scale);
        this.refreshToolbar();
        this.refreshSignals();
        this.refreshNavigation();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.source == null) {
            throw new RuntimeException("Reel source not defined");
        }
        ((ReelNotifier)this.notifier).setup(new ReelSetup().name(this.source.name()).scales(this.source.scales().stream().map(Enum::name).collect(Collectors.toList())).toolbar(this.toolbar()).signals(this.source.signals().stream().map(this::schemaOf).collect(Collectors.toList())).navigation(this.navigation()));
    }

    public void fetch(ReelFetch fetch) {
    }

    private Scale selectedScale() {
        return this.selectedScale != null ? this.selectedScale : this.source.scales().get(0);
    }

    private void selectInstant(Scale scale, Instant value) {
        this.selectedInstants.put(scale, value);
        this.refreshToolbar();
        this.refreshSignals();
    }

    private void refreshToolbar() {
        ((ReelNotifier)this.notifier).refreshToolbar(this.toolbar());
    }

    private void refreshSignals() {
        ((ReelNotifier)this.notifier).refreshSignals(this.source.signals().stream().map(this::schemaOf).collect(Collectors.toList()));
    }

    private void refreshNavigation() {
        ((ReelNotifier)this.notifier).refreshNavigation(this.navigation());
    }

    private ReelNavigationInfo navigation() {
        Scale scale = this.selectedScale();
        Instant current = this.source.from(scale);
        Instant to = this.source.to(scale);
        int steps = 0;
        while (current != to && current.isBefore(to)) {
            ++steps;
            current = this.source.next(current, scale);
        }
        return new ReelNavigationInfo().steps(steps);
    }

    private ReelSignal schemaOf(SignalDefinition definition) {
        return this.schemaOf(this.signal(definition));
    }

    private ReelSignal schemaOf(ReelDatasource.Signal signal) {
        SignalDefinition definition = signal.definition();
        Scale scale = this.selectedScale();
        Instant to = this.selectedInstant(scale);
        Instant from = LocalDateTime.ofInstant(to, ZoneId.of("UTC")).minus(this.stepsCount, scale.temporalUnit()).toInstant(ZoneOffset.UTC);
        String reel = signal.reel(scale, from, to);
        return new ReelSignal().name(definition.name()).type(definition.type().name()).label(definition.label(this.language())).color(definition.color()).steps(this.stepsOf(this.fillWithZeros(reel), from));
    }

    private String fillWithZeros(String reel) {
        return String.format("%1$" + this.stepsCount + "s", reel);
    }

    private List<ReelSignalStep> stepsOf(String reel, Instant from) {
        Scale scale = this.selectedScale();
        Instant current = from;
        ArrayList<ReelSignalStep> result = new ArrayList<ReelSignalStep>();
        for (int i = 0; i < reel.length(); ++i) {
            result.add(new ReelSignalStep().value(String.valueOf(reel.charAt(i))).date(ScaleFormatter.label(current, scale, this.language())));
            current = this.source.next(current, scale);
        }
        return result;
    }

    private ReelDatasource.Signal signal(SignalDefinition definition) {
        return this.source.signal(definition);
    }

    private ReelToolbarInfo toolbar() {
        Scale scale = this.selectedScale();
        Instant date = this.selectedInstant(scale);
        ReelToolbarInfo result = new ReelToolbarInfo();
        result.label(ScaleFormatter.label(date, scale, this.language()));
        result.scale(this.selectedScale().name());
        result.canPrevious(!ScaleFormatter.label(date, scale, this.language()).equals(ScaleFormatter.label(this.source.from(scale), scale, this.language())));
        result.canNext(!ScaleFormatter.label(date, scale, this.language()).equals(ScaleFormatter.label(this.source.to(scale), scale, this.language())));
        return result;
    }

    private Instant selectedInstant() {
        return this.selectedInstant(this.selectedScale());
    }

    private Instant selectedInstant(Scale scale) {
        return this.selectedInstants.getOrDefault(scale, this.source.to(this.selectedScale()));
    }
}

