/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.GridCell;
import io.intino.alexandria.schemas.GridCellInfo;
import io.intino.alexandria.schemas.GridColumn;
import io.intino.alexandria.schemas.GridColumnMode;
import io.intino.alexandria.schemas.GridGroupByInfo;
import io.intino.alexandria.schemas.GridGroupByOptionsInfo;
import io.intino.alexandria.schemas.GridInfo;
import io.intino.alexandria.schemas.GridRow;
import io.intino.alexandria.schemas.GridSortInfo;
import io.intino.alexandria.schemas.GridState;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractGrid;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.GridCollectionBehavior;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.collection.CellClickEvent;
import io.intino.alexandria.ui.displays.events.collection.CellClickListener;
import io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;
import io.intino.alexandria.ui.displays.events.collection.SortColumnListener;
import io.intino.alexandria.ui.displays.notifiers.GridNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.GridDatasource;
import io.intino.alexandria.ui.model.datasource.grid.GridColumn;
import io.intino.alexandria.ui.model.datasource.grid.GridGroupBy;
import io.intino.alexandria.ui.model.datasource.grid.GridItem;
import io.intino.alexandria.ui.model.datasource.grid.GridValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Grid<DN extends GridNotifier, B extends Box, Item>
extends AbstractGrid<DN, B>
implements Collection<Display, Item> {
    private SortColumnListener sortColumnListener;
    private CellClickListener cellClickListener;
    private List<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>> columns = new ArrayList<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>>();
    private List<GridColumn> visibleColumns = new ArrayList<GridColumn>();
    private ItemResolver<Item> itemResolver;
    private List<Item> items = new ArrayList<Item>();

    public Grid(B box) {
        super(box);
    }

    @Override
    protected AddItemEvent itemEvent(Display c, int index) {
        return null;
    }

    @Override
    public <D extends Datasource> void source(D source) {
        GridDatasource gridDatasource = (GridDatasource)source;
        ((GridNotifier)this.notifier).refreshInfo(new GridInfo().name(((GridDatasource)source).name()).columns(this.schemaOf(this.columns)).modes(this.schemaModesOf(gridDatasource.columnModes())));
        this.source(source, new GridCollectionBehavior(this));
        ((GridNotifier)this.notifier).loadState(((GridDatasource)source).name());
    }

    public void itemResolver(ItemResolver<Item> resolver) {
        this.itemResolver = resolver;
    }

    public io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item> column(String name) {
        return this.columns().stream().filter((? super T c) -> c.name().equals(name)).findFirst().orElse(null);
    }

    public List<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>> columns() {
        return this.columns;
    }

    public List<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>> visibleColumns() {
        return this.columns.stream().filter(this::isVisible).collect(Collectors.toList());
    }

    public Grid<DN, B, Item> visibleColumns(List<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>> columns) {
        this.updateVisibleColumns(this.schemaOf(columns));
        return this;
    }

    public void updateVisibleColumns(List<GridColumn> visibleColumns) {
        this.visibleColumns = visibleColumns;
        ((GridNotifier)this.notifier).refreshVisibleColumns(visibleColumns);
    }

    public Grid<DN, B, Item> onSortColumn(SortColumnListener listener) {
        this.sortColumnListener = listener;
        return this;
    }

    public Grid<DN, B, Item> onClickCell(CellClickListener listener) {
        this.cellClickListener = listener;
        return this;
    }

    public void sort(GridSortInfo info) {
        if (this.sortColumnListener == null) {
            return;
        }
        SortColumnEvent.Mode mode = info.mode() != null ? SortColumnEvent.Mode.from(info.mode()) : SortColumnEvent.Mode.None;
        ((GridNotifier)this.notifier).refreshSort(info);
        this.sortColumnListener.accept(new SortColumnEvent(this, this.column(info.column()), mode));
    }

    public void updateState(GridState state) {
        if (state == null) {
            return;
        }
        if (!state.visibleColumns().isEmpty()) {
            this.updateVisibleColumns(state.visibleColumns());
        }
        if (state.sort() != null && SortColumnEvent.Mode.from(state.sort().mode()) != SortColumnEvent.Mode.None) {
            this.sort(state.sort());
        }
        if (state.groupBy() != null) {
            this.updateGroupByOptions(new GridGroupByOptionsInfo().column(state.groupBy().column()).mode(state.groupBy().mode()));
            this.groupBy(state.groupBy());
        }
    }

    public void updateGroupByOptions(GridGroupByOptionsInfo info) {
        GridCollectionBehavior behavior = (GridCollectionBehavior)this.behavior();
        this.refreshGroupByOptions(info);
        if (behavior.groupBy() != null) {
            behavior.groupBy(null);
        }
    }

    public void groupBy(GridGroupByInfo info) {
        GridCollectionBehavior behavior = (GridCollectionBehavior)this.behavior();
        ((GridNotifier)this.notifier).refreshGroupBy(info);
        behavior.groupBy(info.group() != null ? this.groupByOf(info) : null);
    }

    private void refreshGroupByOptions(GridGroupByOptionsInfo info) {
        GridCollectionBehavior behavior = (GridCollectionBehavior)this.behavior();
        GridDatasource source = (GridDatasource)this.source();
        List<String> groupByOptions = info.column() != null ? source.columnGroups(this.column(info.column()), info.mode(), behavior.condition(), behavior.filters()) : Collections.emptyList();
        ((GridNotifier)this.notifier).refreshGroupByOptions(groupByOptions);
    }

    private GridGroupBy groupByOf(GridGroupByInfo info) {
        return new GridGroupBy().column(this.column(info.column())).group(info.group()).groupIndex(info.groupIndex()).mode(info.mode());
    }

    public void cellClick(GridCellInfo info) {
        if (this.cellClickListener == null) {
            return;
        }
        Object item = this.items.size() > info.rowIndex() ? this.items.get(info.rowIndex()) : null;
        this.cellClickListener.accept(new CellClickEvent(this, info.column(), info.row(), item));
    }

    protected Grid<DN, B, Item> _add(io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item> column) {
        this.columns.add(column);
        return this;
    }

    private List<GridColumn> schemaOf(List<io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item>> columns) {
        return columns.stream().map(this::schemaOf).collect(Collectors.toList());
    }

    private GridColumn schemaOf(io.intino.alexandria.ui.model.datasource.grid.GridColumn<?> column) {
        GridColumn result = new GridColumn();
        result.name(column.name());
        result.label(column.label());
        result.type(GridColumn.Type.valueOf(column.type().name()));
        result.sortable(column.sortable());
        result.fixed(column.fixed());
        result.width(column.width());
        result.visible(column.visible());
        return result;
    }

    private List<GridColumnMode> schemaModesOf(List<io.intino.alexandria.ui.model.datasource.grid.GridColumnMode> columnModes) {
        return columnModes.stream().map(this::schemaOf).collect(Collectors.toList());
    }

    private GridColumnMode schemaOf(io.intino.alexandria.ui.model.datasource.grid.GridColumnMode columnMode) {
        List<GridColumnMode.AcceptedTypes> acceptedTypes = columnMode.acceptedTypes().stream().map(a -> GridColumnMode.AcceptedTypes.valueOf(a.name())).collect(Collectors.toList());
        return new GridColumnMode().name(columnMode.name()).acceptedTypes(acceptedTypes);
    }

    @Override
    public Display add(Item item) {
        this.items.add(item);
        ((GridNotifier)this.notifier).addRow(this.schemaOf(item));
        return null;
    }

    @Override
    public List<Display> add(List<Item> items) {
        this.items.addAll(items);
        ((GridNotifier)this.notifier).addRows(items.stream().map(this::schemaOf).collect(Collectors.toList()));
        return null;
    }

    @Override
    public Display insert(Item item, int index) {
        this.items.add(index, item);
        ((GridNotifier)this.notifier).addRow(this.schemaOf(item));
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.items.clear();
    }

    @Override
    public List<Display> insert(List<Item> items, int from) {
        this.items.addAll(Math.min(from, this.items.size()), items);
        ((GridNotifier)this.notifier).addRows(items.stream().map(this::schemaOf).collect(Collectors.toList()));
        return null;
    }

    @Override
    public Display create(Item gridItem) {
        return null;
    }

    @Override
    protected List<Object> itemsOf(List<String> selection) {
        return selection.stream().map(this::itemOf).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Item itemOf(String indexValue) {
        int index = Integer.parseInt(indexValue);
        return index < this.items.size() ? (Item)this.items.get(index) : null;
    }

    private GridRow schemaOf(Item item) {
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridItem gridItem = this.itemResolver.build(item);
        for (int i = 0; i < gridItem.values().size(); ++i) {
            GridCell schemaOf = this.schemaOf(gridItem.values().get(i), i, item);
            cells.add(schemaOf);
        }
        return new GridRow().cells(cells);
    }

    private GridCell schemaOf(GridValue value, int index, Item item) {
        io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item> column = this.columns.get(index);
        GridCell result = new GridCell();
        result.value(column.formatter().apply(value));
        if (column.type() == GridColumn.Type.Link) {
            result.address(this.itemResolver.address(column, item));
        }
        return result;
    }

    private boolean isVisible(io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item> column) {
        GridColumn result = this.visibleColumns.stream().filter((? super T c) -> c.name().equals(column.name())).findFirst().orElse(null);
        return result != null ? result.visible() : false;
    }

    public static interface ItemResolver<Item> {
        public GridItem build(Item var1);

        public String address(io.intino.alexandria.ui.model.datasource.grid.GridColumn<Item> var1, Item var2);
    }
}

