/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Group;
import io.intino.alexandria.schemas.GroupEntry;
import io.intino.alexandria.ui.displays.components.AbstractBaseGrouping;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.GroupingToolbar;
import io.intino.alexandria.ui.displays.components.addressable.Addressable;
import io.intino.alexandria.ui.displays.components.collection.CollectionAddressResolver;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.notifiers.BaseGroupingNotifier;
import io.intino.alexandria.ui.model.Datasource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class BaseGrouping<DN extends BaseGroupingNotifier, B extends Box>
extends AbstractBaseGrouping<DN, B>
implements Addressable {
    private List<Collection> collections = new ArrayList<Collection>();
    private List<String> selection;
    private SelectionListener selectionListener;
    private SelectionListener attachedListener;
    private Map<String, List<io.intino.alexandria.ui.model.datasource.Group>> groups = new HashMap<String, List<io.intino.alexandria.ui.model.datasource.Group>>();
    private GroupingToolbar toolbar;
    private String path;
    private String address;

    public BaseGrouping(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.selection != null) {
            ((BaseGroupingNotifier)this.notifier).refreshSelection(this.selection);
        }
        ((BaseGroupingNotifier)this.notifier).refreshVisibility(this.isVisible());
    }

    @Override
    public String path() {
        return this.path;
    }

    public List<String> selection() {
        return this.namesOf(this.selection);
    }

    public BaseGrouping onSelect(SelectionListener listener) {
        this.selectionListener = listener;
        return this;
    }

    public BaseGrouping onAttachedChanges(SelectionListener listener) {
        this.attachedListener = listener;
        return this;
    }

    public BaseGrouping<DN, B> groups(List<io.intino.alexandria.ui.model.datasource.Group> groups) {
        this._groups(groups);
        this.refresh();
        return this;
    }

    protected BaseGrouping<DN, B> _path(String path) {
        this.path = path;
        this._address(path);
        return this;
    }

    protected BaseGrouping<DN, B> _address(String address) {
        this.address = address;
        return this;
    }

    protected void address(String value) {
        this._address(value);
    }

    public void setupAddress(List<String> groups) {
        if (this.address == null || this.collections.size() <= 0) {
            this.select(groups);
            return;
        }
        String queryString = CollectionAddressResolver.queryString(this.collections.get(0), this.key(), groups);
        if (queryString == null) {
            this.select(groups);
            return;
        }
        ((BaseGroupingNotifier)this.notifier).addressed(this.address + (this.address.contains("?") ? ":" : "?") + queryString);
        ((BaseGroupingNotifier)this.notifier).registerSelection(groups);
        this.select(groups);
    }

    public void select(List<String> groups) {
        this.selection = new ArrayList<String>(groups);
        this.notifySelection();
        this.notifyBindings();
        ((BaseGroupingNotifier)this.notifier).addressed(null);
    }

    public BaseGrouping<DN, B> bindTo(GroupingToolbar toolbar) {
        this.toolbar = toolbar;
        return this;
    }

    public BaseGrouping<DN, B> bindTo(Collection ... collections) {
        this.collections = Arrays.stream(collections).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.collections.size() > 0) {
            Collection collection = this.collections.get(0);
            if (collection.ready()) {
                this.loadGroups();
            } else {
                collection.onReady(event -> this.loadGroups());
            }
        }
        return this;
    }

    public BaseGrouping<DN, B> attachTo(BaseGrouping<?, ?> grouping) {
        grouping.onSelect(e -> this.notifyAttachedChanges(e.selection()));
        return this;
    }

    public String key() {
        return this.label() != null && !this.label().isEmpty() ? this.label() : this.name();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.groups.size() > 0) {
            this.refreshGroups();
        }
    }

    protected List<Collection> _collectionBindings() {
        return this.collections;
    }

    protected List<io.intino.alexandria.ui.model.datasource.Group> groupsOf(List<String> names) {
        List<io.intino.alexandria.ui.model.datasource.Group> groups = this.flattenGroups();
        return names.stream().map(name -> this.findGroup((String)name, groups)).collect(Collectors.toList());
    }

    protected BaseGrouping _groups(List<io.intino.alexandria.ui.model.datasource.Group> groups) {
        this.groups = groups.stream().collect(Collectors.groupingBy(g -> g.category() != null ? g.category() : "default"));
        return this;
    }

    private void loadGroups() {
        if (this.collections.size() <= 0) {
            return;
        }
        Collection collection = this.collections.get(0);
        if (collection.source() == null) {
            return;
        }
        this._groups(((Datasource)collection.source()).groups(this.key()));
        this.refreshGroups();
    }

    private void refreshGroups() {
        ((BaseGroupingNotifier)this.notifier).refreshGroups(this.groups.entrySet().stream().map(this::groupOf).collect(Collectors.toList()));
    }

    private void notifySelection() {
        ((BaseGroupingNotifier)this.notifier).refreshSelection(this.selection);
        if (this.selectionListener != null) {
            this.selectionListener.accept(new SelectionEvent(this, this.namesOf(this.selection)));
        }
    }

    private void notifyBindings() {
        if (this.toolbar != null) {
            this.toolbar.filter(this.key(), this.namesOf(this.selection));
        } else {
            this.collections.forEach(c -> c.filter(this.key(), this.namesOf(this.selection)));
        }
    }

    private List<String> namesOf(List<String> selection) {
        List<io.intino.alexandria.ui.model.datasource.Group> groups = this.flattenGroups();
        return selection != null ? selection.stream().map(v -> this.findGroup((String)v, groups).name()).collect(Collectors.toList()) : null;
    }

    private GroupEntry groupOf(Map.Entry<String, List<io.intino.alexandria.ui.model.datasource.Group>> group) {
        return new GroupEntry().label(group.getKey()).groups(group.getValue().stream().map(this::groupOf).collect(Collectors.toList()));
    }

    private Group groupOf(io.intino.alexandria.ui.model.datasource.Group group) {
        return new Group().label(group.label()).count(group.count()).color(group.color());
    }

    private io.intino.alexandria.ui.model.datasource.Group findGroup(String key, List<io.intino.alexandria.ui.model.datasource.Group> in) {
        return in.stream().filter(g -> g.name().equals(key) || g.label().equals(key)).findFirst().orElse(null);
    }

    private void notifyAttachedChanges(List<String> selection) {
        if (this.attachedListener == null) {
            return;
        }
        this.attachedListener.accept(new SelectionEvent(this, selection));
    }

    private List<io.intino.alexandria.ui.model.datasource.Group> flattenGroups() {
        return this.groups.values().stream().flatMap(java.util.Collection::stream).collect(Collectors.toList());
    }
}

