/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark.pages;

import io.intino.alexandria.ui.resources.Asset;
import io.intino.alexandria.ui.services.push.Browser;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.spark.pages.Unit;
import io.intino.alexandria.ui.utils.StreamUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Page {
    private final String uiServiceName;
    public UISession session;
    public String clientId;
    public String googleApiKey;
    public String device;
    public String token;
    private static final String AppSeparator = "_##_";
    private static final String TemplateName = "/www/%s/%s.html";

    public Page(String uiServiceName) {
        this.uiServiceName = uiServiceName;
    }

    public boolean hasPermissions() {
        return true;
    }

    public String redirectUrl() {
        return this.session.browser().baseUrl();
    }

    protected abstract String title();

    protected abstract URL favicon();

    protected String template(String name) {
        return this.template(name, Collections.emptyList());
    }

    protected String template(String name, List<Unit> usedUnits) {
        try {
            byte[] templateBytes = StreamUtil.readBytes(Page.class.getResourceAsStream(String.format(TemplateName, this.uiServiceName, name)));
            String result = new String(templateBytes);
            result = this.addTemplateVariables(result, usedUnits);
            return result;
        }
        catch (IOException e) {
            return "";
        }
    }

    protected String addTemplateVariables(String template, List<Unit> usedUnits) {
        String sessionId = this.session.id();
        String language = this.session.discoverLanguage();
        Browser browser = this.session.browser();
        template = template.replaceAll("\\$title", this.title() != null ? this.title() : "");
        template = template.replaceAll("\\$language", language != null ? language : "");
        template = template.replaceAll("\\$currentSession", sessionId);
        template = template.replaceAll("\\$client", this.clientId);
        template = template.replaceAll("\\$baseUrls", String.join((CharSequence)",", this.baseUrls(usedUnits, browser)));
        template = template.replaceAll("\\$baseUrl", browser.baseUrl());
        template = template.replaceAll("\\$basePath", browser.basePath());
        template = template.replaceAll("\\$url", browser.baseUrl() + "/" + this.uiServiceName);
        template = template.replaceAll("\\$pushConnections", String.join((CharSequence)",", this.pushConnections(usedUnits, sessionId, language, browser)));
        template = template.replaceAll("\\$googleApiKey", this.googleApiKey != null ? this.googleApiKey : "");
        template = template.replaceAll("\\$favicon", this.favicon() != null ? Asset.toResource(this.baseAssetUrl(), this.favicon()).toUrl().toString() : "");
        return template;
    }

    private List<String> pushConnections(List<Unit> usedUnits, String sessionId, String language, Browser browser) {
        List<String> pushList = usedUnits.stream().filter(unit -> unit != null && !unit.url().isEmpty()).map(unit -> unit.name() + AppSeparator + browser.pushUrl(sessionId, this.clientId, language, unit.url())).collect(Collectors.toList());
        pushList.add("Default_##_" + browser.pushUrl(sessionId, this.clientId, language));
        return pushList;
    }

    private List<String> baseUrls(List<Unit> usedUnits, Browser browser) {
        List<String> pushList = usedUnits.stream().filter(unit -> unit != null && !unit.url().isEmpty()).map(unit -> unit.name() + AppSeparator + unit.url()).collect(Collectors.toList());
        pushList.add("Default_##_" + browser.baseUrl());
        return pushList;
    }

    private URL baseAssetUrl() {
        try {
            return new URL(this.session.browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

