/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Base64;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.AbstractSignDocument;
import io.intino.alexandria.ui.displays.components.SignAction;
import io.intino.alexandria.ui.displays.notifiers.SignDocumentNotifier;
import io.intino.alexandria.ui.utils.IOUtils;
import java.io.IOException;
import java.net.URL;

public class SignDocument<DN extends SignDocumentNotifier, B extends Box>
extends AbstractSignDocument<DN, B> {
    private String signData;

    public SignDocument(B box) {
        super(box);
        this._signFormat(SignAction.SignFormat.PAdES);
    }

    public void document(URL document) {
        this.signData = this.signData(document);
    }

    public void execute() {
        ((SignDocumentNotifier)this.notifier).refreshReadonly(true);
        this.sign(this.signData);
    }

    private String signData(URL document) {
        try {
            return Base64.encode((byte[])IOUtils.toByteArray(document));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

