/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Highlight;
import io.intino.alexandria.ui.displays.components.AbstractBaseText;
import io.intino.alexandria.ui.displays.notifiers.BaseTextNotifier;

public class BaseText<DN extends BaseTextNotifier, B extends Box>
extends AbstractBaseText<DN, B> {
    private String value;
    private String textColor = null;
    private String backgroundColor = null;

    public BaseText(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        ((BaseTextNotifier)this.notifier).refresh(this.value);
    }

    @Override
    public void update() {
        super.update();
        ((BaseTextNotifier)this.notifier).refresh(this.value);
    }

    public String value() {
        return this.value;
    }

    public void value(String value) {
        this._value(value);
        ((BaseTextNotifier)this.notifier).refresh(value);
    }

    public void error(String error) {
        ((BaseTextNotifier)this.notifier).refreshError(error);
    }

    protected BaseText<DN, B> _value(String value) {
        this.value = value;
        return this;
    }

    protected BaseText<DN, B> _textColor(String color) {
        this.textColor = color;
        return this;
    }

    protected BaseText<DN, B> _backgroundColor(String color) {
        this.backgroundColor = color;
        return this;
    }

    protected BaseText<DN, B> _refreshHighlight() {
        if (this.textColor == null && this.backgroundColor == null) {
            return this;
        }
        ((BaseTextNotifier)this.notifier).refreshHighlight(new Highlight().textColor(this.textColor).backgroundColor(this.backgroundColor));
        return this;
    }
}

