/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.KeyPressEventData;
import io.intino.alexandria.ui.displays.components.AbstractTextEditable;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.KeyPressEvent;
import io.intino.alexandria.ui.displays.events.KeyPressListener;
import io.intino.alexandria.ui.displays.notifiers.TextEditableNotifier;

public class TextEditable<DN extends TextEditableNotifier, B extends Box>
extends AbstractTextEditable<DN, B>
implements Editable<DN, B> {
    private boolean readonly;
    private ChangeListener changeListener = null;
    private KeyPressListener keyPressListener = null;
    private KeyPressListener enterPressListener = null;
    private static final String EnterKeyCode = "Enter";

    public TextEditable(B box) {
        super(box);
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((TextEditableNotifier)this.notifier).refresh(this.value());
    }

    @Override
    public TextEditable<DN, B> focus() {
        ((TextEditableNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public TextEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        ((TextEditableNotifier)this.notifier).refreshReadonly(readonly);
        return this;
    }

    @Override
    public TextEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    public TextEditable<DN, B> onKeyPress(KeyPressListener listener) {
        this.keyPressListener = listener;
        return this;
    }

    public TextEditable<DN, B> onEnterPress(KeyPressListener listener) {
        this.enterPressListener = listener;
        return this;
    }

    public void notifyChange(String value) {
        this._value(value);
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    public void notifyKeyPress(KeyPressEventData data) {
        this._value(data.value());
        KeyPressEvent event = new KeyPressEvent(this, data.value(), data.keyCode());
        if (this.keyPressListener != null) {
            this.keyPressListener.accept(event);
        }
        if (this.enterPressListener != null && data.keyCode().equals(EnterKeyCode)) {
            this.enterPressListener.accept(event);
        }
    }

    protected TextEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }
}

