package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseDigitalSignature;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.spark.UISparkManager;

public class BaseDigitalSignaturePushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		BaseDigitalSignature display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("success")) {
			display.success(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DigitalSignatureSuccess.class));
			return;
		}
		else if (operation.equals("failure")) {
			display.failure(io.intino.alexandria.Json.fromString(data, io.intino.alexandria.schemas.DigitalSignatureFailure.class));
			return;
		}

		super.execute(client, message);
	}

}