/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark.resources;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.AssetLoader;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.Resource;
import io.intino.alexandria.ui.spark.resources.exceptions.AssetNotFoundException;
import io.intino.alexandria.ui.utils.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import spark.utils.IOUtils;

public class AssetResource
extends Resource {
    private final AssetLoader loader;

    public AssetResource(AssetLoader loader, UISparkManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws AlexandriaException {
        InputStream inputStream;
        block6: {
            super.execute();
            String name = this.assetName();
            String contentType = this.assetContentTypeOf();
            inputStream = null;
            if (this.isAssetPathRelative(name)) {
                name = this.loader.asset(name).toString();
            }
            try {
                inputStream = new URL(name).openStream();
                if (contentType != null && !contentType.isEmpty()) {
                    byte[] content = IOUtils.toByteArray((InputStream)inputStream);
                    this.manager.write(new String(content, StandardCharsets.UTF_8), contentType);
                    break block6;
                }
                String label = this.manager.fromQueryOrDefault("label", "");
                boolean embedded = Boolean.parseBoolean(this.manager.fromQueryOrDefault("embedded", "false"));
                this.manager.write(inputStream, label, embedded);
            }
            catch (IOException e) {
                try {
                    this.manager.write(new AssetNotFoundException());
                }
                catch (Throwable throwable) {
                    StreamUtil.close(inputStream);
                    throw throwable;
                }
                StreamUtil.close(inputStream);
            }
        }
        StreamUtil.close(inputStream);
    }

    private boolean isAssetPathRelative(String name) {
        try {
            new URL(name);
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    private String assetName() {
        return new String(Base64.getDecoder().decode(this.manager.fromPath("name")));
    }

    private String assetContentTypeOf() {
        String contentType = this.manager.fromQuery("contentType");
        if (contentType == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(contentType));
    }
}

