/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.datasource.grid;

import java.time.Instant;

public class GridValue {
    private Object value;

    public GridValue(Object value) {
        this.value = value;
    }

    public String asText() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.isNumber()) {
            return String.valueOf(this.asNumber());
        }
        if (this.isInstant()) {
            return String.valueOf(this.asInstant());
        }
        return (String)this.value;
    }

    public boolean isNumber() {
        return this.value instanceof Double || this.value instanceof Integer;
    }

    public Double asNumber() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Integer) {
            return ((Integer)this.value).doubleValue();
        }
        return Double.parseDouble((String)this.value);
    }

    public boolean isInstant() {
        return this.value instanceof Instant;
    }

    public Instant asInstant() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Instant) {
            return (Instant)this.value;
        }
        if (this.value instanceof Long) {
            return Instant.ofEpochMilli((Long)this.value);
        }
        return Instant.parse((String)this.value);
    }

    public GridValue value(Object value) {
        this.value = value;
        return this;
    }
}

