/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DigitalSignatureAutoFirmaSetup;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.components.AbstractDigitalSignatureAutoFirma;
import io.intino.alexandria.ui.displays.components.BaseDigitalSignature;
import io.intino.alexandria.ui.displays.components.digitalsignature.AutoFirmaServer;
import io.intino.alexandria.ui.displays.notifiers.DigitalSignatureAutoFirmaNotifier;
import io.intino.icod.core.SignatureInfo;
import io.intino.icod.core.XadesSignatureHelper;

public class DigitalSignatureAutoFirma<DN extends DigitalSignatureAutoFirmaNotifier, B extends Box>
extends AbstractDigitalSignatureAutoFirma<DN, B> {
    private AutoFirmaServer server;
    private SignFormat format = SignFormat.XAdES;

    public DigitalSignatureAutoFirma(B box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.server = new AutoFirmaServer((AlexandriaUiBox)((Object)this.box()), this.session()).listen();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        ((DigitalSignatureAutoFirmaNotifier)this.notifier).setup(this.setup());
    }

    public BaseDigitalSignature<DN, B> signFormat(SignFormat format) {
        this._signFormat(format);
        ((DigitalSignatureAutoFirmaNotifier)this.notifier).format(format.name());
        return this;
    }

    @Override
    protected SignatureInfo info(String signature) {
        if (this.format != SignFormat.XAdES) {
            return new SignatureInfo(null, null, null);
        }
        return new XadesSignatureHelper().getInfo(signature);
    }

    protected BaseDigitalSignature<DN, B> _signFormat(SignFormat format) {
        this.format = format;
        return this;
    }

    private DigitalSignatureAutoFirmaSetup setup() {
        DigitalSignatureAutoFirmaSetup result = new DigitalSignatureAutoFirmaSetup();
        result.downloadUrl(this.server.downloadUrl());
        result.storageUrl(this.server.storageUrl());
        result.retrieveUrl(this.server.retrieveUrl());
        return result;
    }

    public static enum SignFormat {
        XAdES,
        CAdES;

    }
}

